package com.zehong.web.controller.gasBottleTrack;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.BaseInfoStatistics;
import com.zehong.system.domain.TGasStorageStationInfo;
import com.zehong.system.domain.TGasUserInfolins;
import com.zehong.system.service.ITGasStorageStationInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.ArrayList;
import java.util.List;

/**
 * 储配站信息Controller
 *
 * @author zehong
 * @date 2023-08-14
 */
@RestController
@RequestMapping("/gasBottleTrack/storageStationManage")
public class TGasStorageStationInfoController extends BaseController
{
    @Autowired
    private ITGasStorageStationInfoService tGasStorageStationInfoService;

    /**
     * 查询储配站信息列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TGasStorageStationInfo tGasStorageStationInfo)
    {
        startPage();
        List<TGasStorageStationInfo> list = tGasStorageStationInfoService.selectTGasStorageStationInfoList(tGasStorageStationInfo);
        return getDataTable(list);
    }

    @GetMapping("/gasStorageStationList")
    public AjaxResult gasStorageStationList(TGasStorageStationInfo tGasStorageStationInfo){
        List<TGasStorageStationInfo> list = tGasStorageStationInfoService.selectTGasStorageStationInfoList(tGasStorageStationInfo);
        return AjaxResult.success(list);
    }


    /**
     * 微信小程序储配站搜索接口
     * @param tGasStorageStationInfo
     * @return
     */
    @GetMapping("/storageStationlist")
    public AjaxResult StorageStationList(TGasStorageStationInfo tGasStorageStationInfo){
        List<TGasStorageStationInfo> tGasStorageStationInfos = tGasStorageStationInfoService.selectTGasStorageStationInfoList(tGasStorageStationInfo);
        List list=new ArrayList();
        for (int i=0;i<tGasStorageStationInfos.size();i++){
            TGasUserInfolins tGasUserInfolins=new TGasUserInfolins();
            tGasUserInfolins.setLabel(tGasStorageStationInfos.get(i).getStationName());
            tGasUserInfolins.setValue(String.valueOf(tGasStorageStationInfos.get(i).getStationId()));
            list.add(tGasUserInfolins);
        }
        AjaxResult ajax = AjaxResult.success();
        ajax.put("list", list);
        return ajax;
    }


    /**
     * 导出储配站信息列表
     */
    @Log(title = "储配站信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TGasStorageStationInfo tGasStorageStationInfo)
    {
        List<TGasStorageStationInfo> list = tGasStorageStationInfoService.selectTGasStorageStationInfoList(tGasStorageStationInfo);
        ExcelUtil<TGasStorageStationInfo> util = new ExcelUtil<TGasStorageStationInfo>(TGasStorageStationInfo.class);
        return util.exportExcel(list, "储配站信息数据");
    }

    /**
     * 获取储配站信息详细信息
     */
    @GetMapping(value = "/{stationId}")
    public AjaxResult getInfo(@PathVariable("stationId") Long stationId)
    {
        return AjaxResult.success(tGasStorageStationInfoService.selectTGasStorageStationInfoById(stationId));
    }

    /**
     * 新增储配站信息
     */
    @Log(title = "储配站信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TGasStorageStationInfo tGasStorageStationInfo)
    {
        return toAjax(tGasStorageStationInfoService.insertTGasStorageStationInfo(tGasStorageStationInfo));
    }

    /**
     * 修改储配站信息
     */
    @Log(title = "储配站信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TGasStorageStationInfo tGasStorageStationInfo)
    {
        return toAjax(tGasStorageStationInfoService.updateTGasStorageStationInfo(tGasStorageStationInfo));
    }

    /**
     * 删除储配站信息
     */
    @Log(title = "储配站信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{stationIds}")
    public AjaxResult remove(@PathVariable Long[] stationIds)
    {
        return toAjax(tGasStorageStationInfoService.deleteTGasStorageStationInfoByIds(stationIds));
    }

    /**
     * 储配站导入
     * @param file
     * @param updateSupport
     * @return
     * @throws Exception
     */
    @Log(title = "储配站维护", businessType = BusinessType.IMPORT)
    @PostMapping("/importData")
    public AjaxResult importData(MultipartFile file, boolean updateSupport) throws Exception
    {
        ExcelUtil<TGasStorageStationInfo> util = new ExcelUtil<>(TGasStorageStationInfo.class);
        List<TGasStorageStationInfo> tGasStorageStationInfoList = util.importExcel(file.getInputStream());
        String message = tGasStorageStationInfoService.importTGasStorageStationInfo(tGasStorageStationInfoList, updateSupport);
        return AjaxResult.success(message);
    }

    @GetMapping("/importTemplate")
    public AjaxResult importTemplate(){
        ExcelUtil<TGasStorageStationInfo> util = new ExcelUtil<>(TGasStorageStationInfo.class);
        return util.importTemplateExcel("储配站数据");
    }

    /**
     * 基础信息统计
     * @param stationId 储配站id
     * @return
     */
    @GetMapping("/baseInfoStatistics")
    public TableDataInfo baseInfoStatistics(@RequestParam(value = "stationId",required = false) Long stationId){
        startPage();
        return getDataTable(tGasStorageStationInfoService.baseInfoStatistics(stationId));
    }

    @GetMapping("/baseInfoStatisticsExport")
    public AjaxResult baseInfoStatisticsExport(@RequestParam(value = "stationId",required = false) Long stationId)
    {
        List<BaseInfoStatistics> statistics = tGasStorageStationInfoService.baseInfoStatistics(stationId);
        ExcelUtil<BaseInfoStatistics> util = new ExcelUtil<>(BaseInfoStatistics.class);
        return util.exportExcel(statistics, "基础信息数据");
    }
}
