package com.zehong.web.controller.energency;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TSupMajorHazard;
import com.zehong.system.service.ITSupMajorHazardService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 重大危险源监管Controller
 * 
 * @author zehong
 * @date 2024-04-19
 */
@RestController
@RequestMapping("/majorpollsourcelevel/record")
public class TSupMajorHazardController extends BaseController
{
    @Autowired
    private ITSupMajorHazardService tSupMajorHazardService;

    /**
     * 查询重大危险源监管列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TSupMajorHazard tSupMajorHazard)
    {
        startPage();
        List<TSupMajorHazard> list = tSupMajorHazardService.selectTSupMajorHazardList(tSupMajorHazard);
        return getDataTable(list);
    }

    /**
     * 导出重大危险源监管列表
     */
    @Log(title = "重大危险源监管", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TSupMajorHazard tSupMajorHazard)
    {
        //导出
        List<TSupMajorHazard> list = tSupMajorHazardService.exportselectTSupMajorHazardList(tSupMajorHazard);
        ExcelUtil<TSupMajorHazard> util = new ExcelUtil<TSupMajorHazard>(TSupMajorHazard.class);
        return util.exportExcel(list, "重大危险源监管数据");
    }

    /**
     * 获取重大危险源监管详细信息
     */
    @GetMapping(value = "/{fHazardId}")
    public AjaxResult getInfo(@PathVariable("fHazardId") Long fHazardId)
    {
        return AjaxResult.success(tSupMajorHazardService.selectTSupMajorHazardById(fHazardId));
    }

    /**
     * 新增重大危险源监管
     */
    @Log(title = "重大危险源监管", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TSupMajorHazard tSupMajorHazard)
    {
        return toAjax(tSupMajorHazardService.insertTSupMajorHazard(tSupMajorHazard));
    }

    /**
     * 修改重大危险源监管
     */
    @Log(title = "重大危险源监管", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TSupMajorHazard tSupMajorHazard)
    {
        return toAjax(tSupMajorHazardService.updateTSupMajorHazard(tSupMajorHazard));
    }

    /**
     * 删除重大危险源监管
     */
    @Log(title = "重大危险源监管", businessType = BusinessType.DELETE)
	@DeleteMapping("/{fHazardIds}")
    public AjaxResult remove(@PathVariable Long[] fHazardIds)
    {
        return toAjax(tSupMajorHazardService.deleteTSupMajorHazardByIds(fHazardIds));
    }
}
