package com.zehong.web.controller.common;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TSupervise;
import com.zehong.system.service.ITSuperviseService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 监督检查Controller
 * 
 * @author zehong
 * @date 2024-02-04
 */
@RestController
@RequestMapping("/system/supervise")
public class TSuperviseController extends BaseController
{
    @Autowired
    private ITSuperviseService tSuperviseService;

    /**
     * 查询监督检查列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TSupervise tSupervise)
    {
        startPage();
        List<TSupervise> list = tSuperviseService.selectTSuperviseList(tSupervise);
        return getDataTable(list);
    }

    /**
     * 导出监督检查列表
     */
    @Log(title = "监督检查", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TSupervise tSupervise)
    {
        List<TSupervise> list = tSuperviseService.selectTSuperviseList(tSupervise);
        ExcelUtil<TSupervise> util = new ExcelUtil<TSupervise>(TSupervise.class);
        return util.exportExcel(list, "监督检查数据");
    }

    /**
     * 获取监督检查详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tSuperviseService.selectTSuperviseById(id));
    }

    /**
     * 新增监督检查
     */
    @Log(title = "监督检查", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TSupervise tSupervise)
    {
        return toAjax(tSuperviseService.insertTSupervise(tSupervise));
    }

    /**
     * 修改监督检查
     */
    @Log(title = "监督检查", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TSupervise tSupervise)
    {
        return toAjax(tSuperviseService.updateTSupervise(tSupervise));
    }

    /**
     * 删除监督检查
     */
    @Log(title = "监督检查", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tSuperviseService.deleteTSuperviseByIds(ids));
    }
}
