import request from '@/utils/request'

// 查询第三方施工-涉气第三方施工意外事件列表
export function listInc(query) {
  return request({
    url: '/third/accident/list',
    method: 'get',
    params: query
  })
}

// 查询第三方施工-涉气第三方施工意外事件详细
export function getInc(fConGasProIncId) {
  return request({
    url: '/third/accident/' + fConGasProIncId,
    method: 'get'
  })
}

// 新增第三方施工-涉气第三方施工意外事件
export function addInc(data) {
  return request({
    url: '/third/accident',
    method: 'post',
    data: data
  })
}

// 修改第三方施工-涉气第三方施工意外事件
export function updateInc(data) {
  return request({
    url: '/third/accident',
    method: 'put',
    data: data
  })
}

// 删除第三方施工-涉气第三方施工意外事件
export function delInc(fConGasProIncId) {
  return request({
    url: '/third/accident/' + fConGasProIncId,
    method: 'delete'
  })
}

// 导出第三方施工-涉气第三方施工意外事件
export function exportInc(query) {
  return request({
    url: '/third/accident/export',
    method: 'get',
    params: query
  })
}

export function reportAccidentInfo(query) {
  return request({
    url: '/third/accident/reportAccidentInfo',
    method: 'get',
    params: query
  })
}

export function entReportConGasProInfo(query) {
  return request({
    url: '/third/accident/entReportConGasProInfo',
    method: 'get',
    params: query
  })
}