import request from '@/utils/request'

// 查询巡检任务列表
export function listInfo(query) {
  return request({
    url: '/system/workinfo/list',
    method: 'get',
    params: query
  })
}

// 查询巡检任务详细
export function getInfo(workId) {
  return request({
    url: '/system/workinfo/' + workId,
    method: 'get'
  })
}

// 新增巡检任务
export function addInfo(data) {
  return request({
    url: '/system/workinfo',
    method: 'post',
    data: data
  })
}

// 修改巡检任务
export function updateInfo(data) {
  return request({
    url: '/system/workinfo',
    method: 'put',
    data: data
  })
}

// 删除巡检任务
export function delInfo(workId) {
  return request({
    url: '/system/workinfo/' + workId,
    method: 'delete'
  })
}

// 导出巡检任务
export function exportInfo(query) {
  return request({
    url: '/system/workinfo/export',
    method: 'get',
    params: query
  })
}
