import request from '@/utils/request'

// 查询燃气车辆位置信息列表
export function listVehicle(query) {
  return request({
    url: '/system/vehicleInfo/list',
    method: 'get',
    params: query
  })
}

// 查询燃气车辆位置信息详细
export function getVehicle(vehicleId) {
  return request({
    url: '/system/vehicleInfo/' + vehicleId,
    method: 'get'
  })
}

// 新增燃气车辆位置信息
export function addVehicle(data) {
  return request({
    url: '/system/vehicleInfo',
    method: 'post',
    data: data
  })
}

// 修改燃气车辆位置信息
export function updateVehicle(data) {
  return request({
    url: '/system/vehicleInfo',
    method: 'put',
    data: data
  })
}

// 删除燃气车辆位置信息
export function delVehicle(vehicleLocationId) {
  return request({
    url: '/system/vehicleInfo/' + vehicleLocationId,
    method: 'delete'
  })
}

// 导出燃气车辆位置信息
export function exportVehicle(query) {
  return request({
    url: '/system/vehicleInfo/export',
    method: 'get',
    params: query
  })
}
