import request from '@/utils/request'

// 查询配送记录列表
export function listRecord(query) {
  return request({
    url: '/system/recordn/list',
    method: 'get',
    params: query
  })
}

// 查询配送记录详细
export function getRecord(deliveryRecordId) {
  return request({
    url: '/system/recordn/' + deliveryRecordId,
    method: 'get'
  })
}

// 新增配送记录
export function addRecord(data) {
  return request({
    url: '/system/recordn',
    method: 'post',
    data: data
  })
}

// 修改配送记录
export function updateRecord(data) {
  return request({
    url: '/system/recordn',
    method: 'put',
    data: data
  })
}

// 删除配送记录
export function delRecord(deliveryRecordId) {
  return request({
    url: '/system/recordn/' + deliveryRecordId,
    method: 'delete'
  })
}

// 导出配送记录
export function exportRecord(query) {
  return request({
    url: '/system/recordn/export',
    method: 'get',
    params: query
  })
}
