import request from '@/utils/request'

// 查询事件接报列表
export function listReceive(query) {
  return request({
    url: '/system/receive/list',
    method: 'get',
    params: query
  })
}

// 查询事件接报详细
export function getReceive(id) {
  return request({
    url: '/system/receive/' + id,
    method: 'get'
  })
}

// 新增事件接报
export function addReceive(data) {
  return request({
    url: '/system/receive',
    method: 'post',
    data: data
  })
}

// 修改事件接报
export function updateReceive(data) {
  return request({
    url: '/system/receive',
    method: 'put',
    data: data
  })
}

// 删除事件接报
export function delReceive(id) {
  return request({
    url: '/system/receive/' + id,
    method: 'delete'
  })
}

// 导出事件接报
export function exportReceive(query) {
  return request({
    url: '/system/receive/export',
    method: 'get',
    params: query
  })
}