import request from '@/utils/request'

// 查询燃气隐患列表
export function listInfo(query) {
  return request({
    url: '/system/info/list',
    method: 'get',
    params: query
  })
}
export function listCount(query) {
  return request({
    url: '/system/info/listCount',
    method: 'get',
    params: query
  })
}


// 查询燃气隐患详细
export function getInfo(hiddenTroubleId) {
  return request({
    url: '/system/info/' + hiddenTroubleId,
    method: 'get'
  })
}

// 新增燃气隐患
export function addInfo(data) {
  return request({
    url: '/system/info',
    method: 'post',
    data: data
  })
}

// 修改燃气隐患
export function updateInfo(data) {
  return request({
    url: '/system/info',
    method: 'put',
    data: data
  })
}

// 删除燃气隐患
export function delInfo(hiddenTroubleId) {
  return request({
    url: '/system/info/' + hiddenTroubleId,
    method: 'delete'
  })
}

// 导出燃气隐患
export function exportInfo(query) {
  return request({
    url: '/system/info/export',
    method: 'get',
    params: query
  })
}

//上报
export function reportGovernment(query) {
  return request({
    url: '/system/info/reportGovernment',
    method: 'get',
    params: query
  })
}
