import request from '@/utils/request'

// 查询安全宣传列表
export function listDisseminate(query) {
  return request({
    url: '/system/disseminate/list',
    method: 'get',
    params: query
  })
}

// 查询安全宣传详细
export function getDisseminate(securityId) {
  return request({
    url: '/system/disseminate/' + securityId,
    method: 'get'
  })
}

// 新增安全宣传
export function addDisseminate(data) {
  return request({
    url: '/system/disseminate',
    method: 'post',
    data: data
  })
}

// 修改安全宣传
export function updateDisseminate(data) {
  return request({
    url: '/system/disseminate',
    method: 'put',
    data: data
  })
}

// 删除安全宣传
export function delDisseminate(securityId) {
  return request({
    url: '/system/disseminate/' + securityId,
    method: 'delete'
  })
}

// 导出安全宣传
export function exportDisseminate(query) {
  return request({
    url: '/system/disseminate/export',
    method: 'get',
    params: query
  })
}