import request from '@/utils/request'

// 查询隐患整治台账列表
export function listHidden(query) {
  return request({
    url: '/standingBook/hidden/list',
    method: 'get',
    params: query
  })
}
export function selectHiddenCount() {
  return request({
    url: '/standingBook/hidden/selectCountByMonth',
    method: 'get',
  })
}
export function selectHiddenByYear() {
  return request({
    url: '/standingBook/hidden/selectCountByYear',
    method: 'get',
  })
}
export function selectHiddenRanking() {
  return request({
    url: '/standingBook/hidden/selectHiddenRanking',
    method: 'get',
  })
}
export function selectHiddenSource() {
  return request({
    url: '/standingBook/hidden/selectHiddenSource',
    method: 'get',
  })
}

// 查询隐患整治台账详细
export function getHidden(hiddenId) {
  return request({
    url: '/standingBook/hidden/' + hiddenId,
    method: 'get'
  })
}

// 新增隐患整治台账
export function addHidden(data) {
  return request({
    url: '/standingBook/hidden',
    method: 'post',
    data: data
  })
}

// 修改隐患整治台账
export function updateHidden(data) {
  return request({
    url: '/standingBook/hidden',
    method: 'put',
    data: data
  })
}

// 删除隐患整治台账
export function delHidden(hiddenId) {
  return request({
    url: '/standingBook/hidden/' + hiddenId,
    method: 'delete'
  })
}

// 导出隐患整治台账
export function exportHidden(query) {
  return request({
    url: '/standingBook/hidden/export',
    method: 'get',
    params: query
  })
}


//隐患统计
export function hiddenBookStatistics() {
  return request({
    url: '/standingBook/hidden/hiddenBookStatistics',
    method: 'get',
  })
}
