import request from '@/utils/request'

// 查询行业专家库-专家行为申报列表
export function listInfor(query) {
  return request({
    url: '/specialist/behInfo/list',
    method: 'get',
    params: query
  })
}

// 查询行业专家库-专家行为申报详细
export function getInfor(fProBehInforId) {
  return request({
    url: '/specialist/behInfo/' + fProBehInforId,
    method: 'get'
  })
}

// 新增行业专家库-专家行为申报
export function addInfor(data) {
  return request({
    url: '/specialist/behInfo',
    method: 'post',
    data: data
  })
}

// 修改行业专家库-专家行为申报
export function updateInfor(data) {
  return request({
    url: '/specialist/behInfo',
    method: 'put',
    data: data
  })
}

// 删除行业专家库-专家行为申报
export function delInfor(fProBehInforId) {
  return request({
    url: '/specialist/behInfo/' + fProBehInforId,
    method: 'delete'
  })
}

// 导出行业专家库-专家行为申报
export function exportInfor(query) {
  return request({
    url: '/specialist/behInfo/export',
    method: 'get',
    params: query
  })
}

//申报
export function reportProBehInfo(query) {
  return request({
    url: '/specialist/behInfo/reportProBehInfo',
    method: 'get',
    params: query
  })
}

export function getUserList(query) {
  return request({
    url: '/specialist/behInfo/getUserList',
    method: 'get'
  })
}

