import request from '@/utils/request'

// 查询行业专家库-专家行为浏览列表
export function listBrowse(query) {
  return request({
    url: '/specialist/behBrowse/list',
    method: 'get',
    params: query
  })
}

// 查询行业专家库-专家行为浏览详细
export function getBrowse(fProBehInforId) {
  return request({
    url: '/specialist/behBrowse/' + fProBehInforId,
    method: 'get'
  })
}

// 新增行业专家库-专家行为浏览
export function addBrowse(data) {
  return request({
    url: '/specialist/behBrowse',
    method: 'post',
    data: data
  })
}

// 修改行业专家库-专家行为浏览
export function updateBrowse(data) {
  return request({
    url: '/specialist/behBrowse',
    method: 'put',
    data: data
  })
}

// 删除行业专家库-专家行为浏览
export function delBrowse(fProBehInforId) {
  return request({
    url: '/specialist/behBrowse/' + fProBehInforId,
    method: 'delete'
  })
}

// 导出行业专家库-专家行为浏览
export function exportBrowse(query) {
  return request({
    url: '/specialist/behBrowse/export',
    method: 'get',
    params: query
  })
}

//获取任务
export function getProBehInforBrowseTask(query) {
  return request({
    url: '/government/supervision/getBehaviour',
    method: 'get',
    params: query
  })
}
