import request from '@/utils/request'

// 查询重要风险点管控列表
export function listInfor(query) {
  return request({
    url: '/risk/info/list',
    method: 'get',
    params: query
  })
}

// 查询重要风险点管控详细
export function getInfor(fRiskDevMajInforId) {
  return request({
    url: '/risk/info/' + fRiskDevMajInforId,
    method: 'get'
  })
}

// 查询重要风险点管控详细
export function getInforForDetail(fRiskDevMajInforId) {
  return request({
    url: '/risk/info/getInfoForDetail/' + fRiskDevMajInforId,
    method: 'get'
  })
}
// 新增重要风险点管控
export function addInfor(data) {
  return request({
    url: '/risk/info',
    method: 'post',
    data: data
  })
}

// 修改重要风险点管控
export function updateInfor(data) {
  return request({
    url: '/risk/info',
    method: 'put',
    data: data
  })
}

// 删除重要风险点管控
export function delInfor(fRiskDevMajInforId) {
  return request({
    url: '/risk/info/' + fRiskDevMajInforId,
    method: 'delete'
  })
}

// 导出重要风险点管控
export function exportInfor(query) {
  return request({
    url: '/risk/info/export',
    method: 'get',
    params: query
  })
}

export function reportRiskInfo(query) {
  return request({
    url: '/risk/info/reportRiskInfo',
    method: 'get',
    params: query
  })
}

export function entReportRiskInfo(query) {
  return request({
    url: '/risk/info/entReportRiskInfo',
    method: 'get',
    params: query
  })
}
