import request from '@/utils/request'

// 查询基本信息维护-用户管理-居住区(村庄)列表
export function listVillage(query) {
  return request({
    url: '/system/village/list',
    method: 'get',
    params: query
  })
}

// 查询基本信息维护-用户管理-居住区(村庄)详细
export function getVillage(fVillageId) {
  return request({
    url: '/system/village/' + fVillageId,
    method: 'get'
  })
}

// 新增基本信息维护-用户管理-居住区(村庄)
export function addVillage(data) {
  return request({
    url: '/system/village',
    method: 'post',
    data: data
  })
}

// 修改基本信息维护-用户管理-居住区(村庄)
export function updateVillage(data) {
  return request({
    url: '/system/village',
    method: 'put',
    data: data
  })
}

// 删除基本信息维护-用户管理-居住区(村庄)
export function delVillage(fVillageId) {
  return request({
    url: '/system/village/' + fVillageId,
    method: 'delete'
  })
}

// 导出基本信息维护-用户管理-居住区(村庄)
export function exportVillage(query) {
  return request({
    url: '/system/village/export',
    method: 'get',
    params: query
  })
}


// 查询基本信息维护-用户管理-居住区(村庄)列表-无分页
export function noPageListVillage(query) {
  return request({
    url: '/system/village/noPagelist',
    method: 'get',
    params: query
  })
}
