import request from '@/utils/request'

// 查询设备信息列表
export function listDevice(query) {
  return request({
    url: '/device/device/list',
    method: 'get',
    params: query
  })
}

// 查询设备信息详细
export function getDevice(deviceId) {
  return request({
    url: '/device/device/' + deviceId,
    method: 'get'
  })
}

// 新增设备信息
export function addDevice(data) {
  return request({
    url: '/device/device',
    method: 'post',
    data: data
  })
}

// 修改设备信息
export function updateDevice(data) {
  return request({
    url: '/device/device',
    method: 'put',
    data: data
  })
}

// 删除设备信息
export function delDevice(deviceId) {
  return request({
    url: '/device/device/' + deviceId,
    method: 'delete'
  })
}

// 导出设备信息
export function exportDevice(query) {
  return request({
    url: '/device/device/export',
    method: 'get',
    params: query
  })
}

// 企业信息查询(下拉框)
export function selectTEnterprise() {
  return request({
    url: '/regulation/supervise/selectTEnterprise',
    method: 'get'
  })
}

// 关联设备详情信息
export function getDdeviceDetailInfo(data) {
  return request({
    url: '/device/device/selectDetailInfo',
    method: 'post',
    data:data
  })
}

// 新增关联设备信息
export function addDetailInfos(data) {
  return request({
    url: '/device/device/insertDetailInfo',
    method: 'post',
    data: data
  })
}

  // 删除关联设备信息
  export function deleteDetailInfo(deviceId) {
    return request({
      url: '/device/device/deleteDetailInfo',
      method: 'delete',
      data:deviceId
    })
  }


// 解除 设备与关联设备信息
export function deleteDeviceDetailInfo(deviceId) {
  return request({
    url: '/device/device/deleteDeviceDetailInfo',
    method: 'delete',
    data:deviceId
  })
}


// 删除关联设备信息
export function deleteeListDetailInfo(deviceId) {
  return request({
    url: '/device/device/deleteeListDetailInfo',
    method: 'delete',
    data: deviceId
  })
}

//查询已经关联的关联设备信息
export function selectDetailInfoList(data){
  return request({
    url: '/device/device/selectDetailInfoList',
    method: 'post',
    data: data
  })
}

// 新增设备信息
export function updateDetailInfoLists(data) {
  return request({
    url: '/device/device/updateDetailInfoList',
    method: 'post',
    data: data
  })
}
