import request from '@/utils/request'

// 查询燃气车辆信息列表
export function listInfo(query) {
  return request({
    url: '/system/vehicleInfo/list',
    method: 'get',
    params: query
  })
}

//获取车辆最终位置
export function getLastLocation(query){
  return request({
    url: '/system/vehicleInfo/getLastLocation',
    method: 'get',
    params: query
  })
}

// 查询燃气车辆信息详细
export function getInfo(vehicleId) {
  return request({
    url: '/system/vehicleInfo/' + vehicleId,
    method: 'get'
  })
}

// 新增燃气车辆信息
export function addInfo(data) {
  return request({
    url: '/system/vehicleInfo',
    method: 'post',
    data: data
  })
}

// 修改燃气车辆信息
export function updateInfo(data) {
  return request({
    url: '/system/vehicleInfo',
    method: 'put',
    data: data
  })
}

// 删除燃气车辆信息
export function delInfo(vehicleId) {
  return request({
    url: '/system/vehicleInfo/' + vehicleId,
    method: 'delete'
  })
}

// 导出燃气车辆信息
export function exportInfo(query) {
  return request({
    url: '/system/vehicleInfo/export',
    method: 'get',
    params: query
  })
}
