import request from '@/utils/request'

// 查询重大危险源监管列表
export function listRecord(query) {
  return request({
    url: '/majorpollsourcelevel/record/list',
    method: 'get',
    params: query
  })
}

// 查询重大危险源监管详细
export function getRecord(fHazardId) {
  return request({
    url: '/majorpollsourcelevel/record/' + fHazardId,
    method: 'get'
  })
}

// 新增重大危险源监管
export function addRecord(data) {
  return request({
    url: '/majorpollsourcelevel/record',
    method: 'post',
    data: data
  })
}

// 修改重大危险源监管
export function updateRecord(data) {
  return request({
    url: '/majorpollsourcelevel/record',
    method: 'put',
    data: data
  })
}

// 删除重大危险源监管
export function delRecord(fHazardId) {
  return request({
    url: '/majorpollsourcelevel/record/' + fHazardId,
    method: 'delete'
  })
}

// 导出重大危险源监管
export function exportRecord(query) {
  return request({
    url: '/majorpollsourcelevel/record/export',
    method: 'get',
    params: query
  })
}