import request from '@/utils/request'

// 查询液化石油配送记录列表
export function listRecord(query) {
  return request({
    url: '/lpg/record/list',
    method: 'get',
    params: query
  })
}

// 查询液化石油配送记录详细
export function getRecord(deliveryRecordId) {
  return request({
    url: '/lpg/record/' + deliveryRecordId,
    method: 'get'
  })
}

// 下载用户导入模板
export function importTemplate() {
  return request({
    url: '/lpg/record/importTemplate',
    method: 'get'
  })
}

// 新增液化石油配送记录
export function addRecord(data) {
  return request({
    url: '/lpg/record',
    method: 'post',
    data: data
  })
}

// 修改液化石油配送记录
export function updateRecord(data) {
  return request({
    url: '/lpg/record',
    method: 'put',
    data: data
  })
}

// 删除液化石油配送记录
export function delRecord(deliveryRecordId) {
  return request({
    url: '/lpg/record/' + deliveryRecordId,
    method: 'delete'
  })
}

// 导出液化石油配送记录
export function exportRecord(query) {
  return request({
    url: '/lpg/record/export',
    method: 'get',
    params: query
  })
}
