import request from '@/utils/request'

// 查询【请填写功能名称】列表
export function listLocation(query) {
  return request({
    url: '/task/location/list',
    method: 'get',
    params: query
  })
}

/**
 * 位置列表不分页
 * @param query
 * @constructor
 */
export function locationListInfo(query) {
  return request({
    url: '/task/location/locationList',
    method: 'get',
    params: query
  })
}

export function selectTUserLocationListByGroup(query) {
  return request({
    url: '/task/location/selectTUserLocationListByGroup',
    method: 'get',
    params: query
  })
}

// 查询【请填写功能名称】详细
export function getLocation(id) {
  return request({
    url: '/task/location/' + id,
    method: 'get'
  })
}

// 新增【请填写功能名称】
export function addLocation(data) {
  return request({
    url: '/task/location',
    method: 'post',
    data: data
  })
}

// 修改【请填写功能名称】
export function updateLocation(data) {
  return request({
    url: '/task/location',
    method: 'put',
    data: data
  })
}

// 删除【请填写功能名称】
export function delLocation(id) {
  return request({
    url: '/task/location/' + id,
    method: 'delete'
  })
}

// 导出【请填写功能名称】
export function exportLocation(query) {
  return request({
    url: '/task/location/export',
    method: 'get',
    params: query
  })
}
