import request from '@/utils/request'

// 查询气瓶追溯列表
export function listRecord(data) {
  return request({
    url: '/track/record/list',
    method: 'post',
    data: data
  })
}

export function bottleTrackRecordList(data) {
  return request({
    url: '/track/record/bottleTrackRecordList',
    method: 'post',
    data: data
  })
}

// 查询气瓶追溯详细
export function getRecord(trackRecordId) {
  return request({
    url: '/track/record/' + trackRecordId,
    method: 'get'
  })
}

// 新增气瓶追溯
export function addRecord(data) {
  return request({
    url: '/track/record',
    method: 'post',
    data: data
  })
}

// 修改气瓶追溯
export function updateRecord(data) {
  return request({
    url: '/track/record',
    method: 'put',
    data: data
  })
}

// 删除气瓶追溯
export function delRecord(trackRecordId) {
  return request({
    url: '/track/record/' + trackRecordId,
    method: 'delete'
  })
}

// 导出气瓶追溯
export function exportRecord(data) {
  return request({
    url: '/track/record/export',
    method: 'post',
    data: data
  })
}
