import request from '@/utils/request'

// 查询燃气用户设备上报的数据列表
export function listDetectorReportData(query) {
  return request({
    url: '/detector/detectorReportData/list',
    method: 'get',
    params: query
  })
}

// 查询燃气用户设备上报的数据详细
export function getDetectorReportData(id) {
  return request({
    url: '/detector/detectorReportData/' + id,
    method: 'get'
  })
}

// 新增燃气用户设备上报的数据
export function addDetectorReportData(data) {
  return request({
    url: '/detector/detectorReportData',
    method: 'post',
    data: data
  })
}

// 修改燃气用户设备上报的数据
export function updateDetectorReportData(data) {
  return request({
    url: '/detector/detectorReportData',
    method: 'put',
    data: data
  })
}

// 删除燃气用户设备上报的数据
export function delDetectorReportData(id) {
  return request({
    url: '/detector/detectorReportData/' + id,
    method: 'delete'
  })
}

// 导出燃气用户设备上报的数据
export function exportDetectorReportData(query) {
  return request({
    url: '/detector/detectorReportData/export',
    method: 'get',
    params: query
  })
}
