/*
 * @Author: your name
 * @Date: 2022-02-26 16:01:37
 * @LastEditTime: 2024-09-07 15:08:36
 * @LastEditors: 纪泽龙 jizelong@qq.com
 * @Description: 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 * @FilePath: /gassafety-progress/gassafetyprogress-web/src/api/detector/detectorInfo.js
 */
import request from "@/utils/request";

// 查询探测器列表
export function listDetectorInfo(query) {
  return request({
    url: "/detector/detectorInfo/list",
    method: "get",
    params: {
      pageNum: 1,
      pageSize: 20,
      ...query,
    },
  });
}
export function yhqlistDetectorInfo(query) {
  return request({
    url: "/system/yehuaqiDevice/list",
    method: "get",
    params: {
      pageNum: 1,
      pageSize: 5,
      ...query,
    },
  });
}
export function getUserList(query) {
  return request({
    url: "/supervise/user/pageQueryLabelsLayerMarksDUser",
    method: "get",
    params: {
      pageNum: 1,
      pageSize: 5,
      ...query,
    },
  });
}
// 探测器列表
export function detectorInfoList(query) {
  return request({
    url: "/detector/detectorInfo/detectorInfoList",
    method: "get",

    params: query,
  });
}

// 新增探测器
export function addDetectorInfo(data) {
  return request({
    url: "/detector/detectorInfo",
    method: "post",
    data: data,
  });
}

// 修改探测器
export function updateDetectorInfo(data) {
  return request({
    url: "/detector/detectorInfo",
    method: "put",
    data: data,
  });
}

// 删除探测器
export function delDetectorInfo(detectorId) {
  return request({
    url: "/detector/detectorInfo/" + detectorId,
    method: "delete",
  });
}

// 导出探测器
export function exportDetectorInfo(query) {
  return request({
    url: "/detector/detectorInfo/export",
    method: "get",
    params: query,
  });
}

// 右上角的综合列表
export function alarmData(query) {
  return request({
    url: "/detector/detectorInfo/getAlarmData",
    method: "get",
    params: query,
  });
}
export function selectDeviceNum(query) {
  return request({
    url: '/device/device/selectDeviceNum',
    method: 'get',
    params: query
  })
}

//数据监控获取探测器数据
export function selectDetectorMointor(query){
  return request({
    url: '/detector/detectorInfo/selectDetectorMointor',
    method: 'get',
    params: {
      pageNum: 1,
      pageSize: 20,
      ...query,
  },
  })
}
