import request from '@/utils/request'

// 查询乡级行政区列表
export function listRegion(query) {
  return request({
    url: '/area/town/list',
    method: 'get',
    params: query
  })
}

// 查询乡级行政区详细
export function getRegion(fId) {
  return request({
    url: '/area/town/' + fId,
    method: 'get'
  })
}

// 新增乡级行政区
export function addRegion(data) {
  return request({
    url: '/area/town',
    method: 'post',
    data: data
  })
}

// 修改乡级行政区
export function updateRegion(data) {
  return request({
    url: '/area/town',
    method: 'put',
    data: data
  })
}

// 删除乡级行政区
export function delRegion(fId) {
  return request({
    url: '/area/town/' + fId,
    method: 'delete'
  })
}

// 导出乡级行政区
export function exportRegion(query) {
  return request({
    url: '/area/town/export',
    method: 'get',
    params: query
  })
}
