import request from '@/utils/request'

// 查询县级行政区列表
export function listRegion(query) {
  return request({
    url: '/area/county/list',
    method: 'get',
    params: query
  })
}

// 查询县级行政区详细
export function getRegion(fId) {
  return request({
    url: '/area/county/' + fId,
    method: 'get'
  })
}

// 新增县级行政区
export function addRegion(data) {
  return request({
    url: '/area/county',
    method: 'post',
    data: data
  })
}

// 修改县级行政区
export function updateRegion(data) {
  return request({
    url: '/area/county',
    method: 'put',
    data: data
  })
}

// 删除县级行政区
export function delRegion(fId) {
  return request({
    url: '/area/county/' + fId,
    method: 'delete'
  })
}

// 导出县级行政区
export function exportRegion(query) {
  return request({
    url: '/area/county/export',
    method: 'get',
    params: query
  })
}

//获取系统设置县
export function getDefaultCountyList() {
  return request({
    url: '/area/county/getDefaultCountyList',
    method: 'get',
  })
}
