package com.zehong.system.service.impl;

import java.util.List;
import java.util.Map;

import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TDetectorUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TWorkTaskInspectMapper;
import com.zehong.system.domain.TWorkTaskInspect;
import com.zehong.system.service.ITWorkTaskInspectService;

/**
 * 入户安检Service业务层处理
 * 
 * @author zehong
 * @date 2023-09-15
 */
@Service
public class TWorkTaskInspectServiceImpl implements ITWorkTaskInspectService 
{
    @Autowired
    private TWorkTaskInspectMapper tWorkTaskInspectMapper;

    /**
     * 查询入户安检
     * 
     * @param inspectId 入户安检ID
     * @return 入户安检
     */
    @Override
    public TWorkTaskInspect selectTWorkTaskInspectById(Long inspectId)
    {
        return tWorkTaskInspectMapper.selectTWorkTaskInspectById(inspectId);
    }

    /**
     * 查询入户安检列表
     * 
     * @param tWorkTaskInspect 入户安检
     * @return 入户安检
     */
    @Override
    public List<TWorkTaskInspect> selectTWorkTaskInspectList(TWorkTaskInspect tWorkTaskInspect)
    {
        return tWorkTaskInspectMapper.selectTWorkTaskInspectList(tWorkTaskInspect);
    }
    @Override
    public List<TWorkTaskInspect> selectTWorkTaskInspectwxList(TWorkTaskInspect tWorkTaskInspect)
    {
        tWorkTaskInspectMapper.updateOld();
        return tWorkTaskInspectMapper.selectTWorkTaskInspectwxList(tWorkTaskInspect);
    }
    @Override
    public List<TDetectorUser> selectTWorkTaskInspectwxnotList(TWorkTaskInspect tWorkTaskInspect)
    {
        tWorkTaskInspectMapper.updateOld();
        return tWorkTaskInspectMapper.selectTWorkTaskInspectwxnotList(tWorkTaskInspect);
    }


    /**
     * 新增入户安检
     * 
     * @param tWorkTaskInspect 入户安检
     * @return 结果
     */
    @Override
    public int insertTWorkTaskInspect(TWorkTaskInspect tWorkTaskInspect)
    {
        tWorkTaskInspect.setCreateTime(DateUtils.getNowDate());
        return tWorkTaskInspectMapper.insertTWorkTaskInspect(tWorkTaskInspect);
    }

    /**
     * 修改入户安检
     * 
     * @param tWorkTaskInspect 入户安检
     * @return 结果
     */
    @Override
    public int updateTWorkTaskInspect(TWorkTaskInspect tWorkTaskInspect)
    {
        return tWorkTaskInspectMapper.updateTWorkTaskInspect(tWorkTaskInspect);
    }

    /**
     * 批量删除入户安检
     * 
     * @param inspectIds 需要删除的入户安检ID
     * @return 结果
     */
    @Override
    public int deleteTWorkTaskInspectByIds(Long[] inspectIds)
    {
        return tWorkTaskInspectMapper.deleteTWorkTaskInspectByIds(inspectIds);
    }

    /**
     * 删除入户安检信息
     * 
     * @param inspectId 入户安检ID
     * @return 结果
     */
    @Override
    public int deleteTWorkTaskInspectById(Long inspectId)
    {
        return tWorkTaskInspectMapper.deleteTWorkTaskInspectById(inspectId);
    }

    /**
     * 入户安检统计
     * @param tWorkTaskInspect 入户安检实体
     * @return
     */
    @Override
    public List<Map<String,Object>> inspectStatistic(TWorkTaskInspect tWorkTaskInspect){
        return tWorkTaskInspectMapper.inspectStatistic(tWorkTaskInspect);
    }

    /**
     * 查询任务已安检用户
     * @param taskId 任务主键
     * @return
     */
    @Override
    public List<Long> getHasInspectByTaskId(Long taskId){
        return tWorkTaskInspectMapper.getHasInspectByTaskId(taskId);
    }
}
