package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TTrainPerson;
import com.zehong.system.mapper.TTrainPersonMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TTrainManageMapper;
import com.zehong.system.domain.TTrainManage;
import com.zehong.system.service.ITTrainManageService;
import org.springframework.transaction.annotation.Transactional;

/**
 * 培训管理Service业务层处理
 * 
 * @author zehong
 * @date 2023-04-21
 */
@Service
public class TTrainManageServiceImpl implements ITTrainManageService 
{
    @Autowired
    private TTrainManageMapper tTrainManageMapper;

    @Autowired
    private TTrainPersonMapper tTrainPersonMapper;

    /**
     * 查询培训管理
     * 
     * @param trainManageId 培训管理ID
     * @return 培训管理
     */
    @Override
    public TTrainManage selectTTrainManageById(Long trainManageId)
    {
        TTrainManage tTrainManage = tTrainManageMapper.selectTTrainManageById(trainManageId);
        TTrainPerson tTrainPerson = new TTrainPerson();
        tTrainPerson.setTrainManageId(tTrainManage.getTrainManageId());
        List<TTrainPerson> personList = tTrainPersonMapper.selectTTrainPersonList(tTrainPerson);
        if(null != personList && personList.size() >0){
            tTrainManage.settTrainPersonList(personList);
        }
        return tTrainManage;
    }

    /**
     * 查询培训管理列表
     * 
     * @param tTrainManage 培训管理
     * @return 培训管理
     */
    @Override
    public List<TTrainManage> selectTTrainManageList(TTrainManage tTrainManage)
    {
        List<TTrainManage> manageList = tTrainManageMapper.selectTTrainManageList(tTrainManage);
        for(TTrainManage manage : manageList){
            TTrainPerson tTrainPerson = new TTrainPerson();
            tTrainPerson.setTrainManageId(manage.getTrainManageId());
            List<TTrainPerson> personList = tTrainPersonMapper.selectTTrainPersonList(tTrainPerson);
            if(null != personList && personList.size() >0){
                manage.settTrainPersonList(personList);
            }
        }
        return manageList;
    }

    /**
     * 新增培训管理
     * 
     * @param tTrainManage 培训管理
     * @return 结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int insertTTrainManage(TTrainManage tTrainManage)
    {
        tTrainManage.setCreateTime(DateUtils.getNowDate());
        int result = tTrainManageMapper.insertTTrainManage(tTrainManage);
        if(1==result && null != tTrainManage.gettTrainPersonList() && tTrainManage.gettTrainPersonList().size() >0){
            tTrainPersonMapper.batchInsertTTrainPerson(tTrainManage.getTrainManageId(),tTrainManage.gettTrainPersonList());
        }
        return result;
    }

    /**
     * 修改培训管理
     * 
     * @param tTrainManage 培训管理
     * @return 结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int updateTTrainManage(TTrainManage tTrainManage)
    {
        tTrainManage.setUpdateTime(DateUtils.getNowDate());
        if(null != tTrainManage.gettTrainPersonList() && tTrainManage.gettTrainPersonList().size()>0){
            tTrainPersonMapper.deleteTTrainPersonByTrainManageId(tTrainManage.getTrainManageId());
            tTrainPersonMapper.batchInsertTTrainPerson(tTrainManage.getTrainManageId(),tTrainManage.gettTrainPersonList());
        }
        return tTrainManageMapper.updateTTrainManage(tTrainManage);
    }

    /**
     * 批量删除培训管理
     * 
     * @param trainManageIds 需要删除的培训管理ID
     * @return 结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int deleteTTrainManageByIds(Long[] trainManageIds)
    {
        for(Long trainMangeId : trainManageIds){
            TTrainPerson tTrainPerson = new TTrainPerson();
            tTrainPerson.setTrainManageId(trainMangeId);
            List<TTrainPerson> personList = tTrainPersonMapper.selectTTrainPersonList(tTrainPerson);
            if(null != personList && personList.size()>0){
                tTrainPersonMapper.deleteTTrainPersonByTrainManageId(trainMangeId);
            }
        }
        return tTrainManageMapper.deleteTTrainManageByIds(trainManageIds);
    }

    /**
     * 删除培训管理信息
     * 
     * @param trainManageId 培训管理ID
     * @return 结果
     */
    @Override
    public int deleteTTrainManageById(Long trainManageId)
    {
        return tTrainManageMapper.deleteTTrainManageById(trainManageId);
}

    /**
     * 根据培训人员查询培训课程
     * @param trainPersonId 培训人员
     * @return
     */
    public List<TTrainManage> getTrainInfoByPersonId(Long trainPersonId){
        return tTrainManageMapper.getTrainInfoByPersonId(trainPersonId);
    }
}
