package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TSupervisorInfoMapper;
import com.zehong.system.domain.TSupervisorInfo;
import com.zehong.system.service.ITSupervisorInfoService;

/**
 * 燃气督办Service业务层处理
 * 
 * @author zehong
 * @date 2022-03-31
 */
@Service
public class TSupervisorInfoServiceImpl implements ITSupervisorInfoService 
{
    @Autowired
    private TSupervisorInfoMapper tSupervisorInfoMapper;

    /**
     * 查询燃气督办
     * 
     * @param supervisorId 燃气督办ID
     * @return 燃气督办
     */
    @Override
    public TSupervisorInfo selectTSupervisorInfoById(Long supervisorId)
    {
        return tSupervisorInfoMapper.selectTSupervisorInfoById(supervisorId);
    }

    /**
     * 查询燃气督办列表
     * 
     * @param tSupervisorInfo 燃气督办
     * @return 燃气督办
     */
    @Override
    public List<TSupervisorInfo> selectTSupervisorInfoList(TSupervisorInfo tSupervisorInfo)
    {
        return tSupervisorInfoMapper.selectTSupervisorInfoList(tSupervisorInfo);
    }

    /**
     * 新增燃气督办
     * 
     * @param tSupervisorInfo 燃气督办
     * @return 结果
     */
    @Override
    public int insertTSupervisorInfo(TSupervisorInfo tSupervisorInfo)
    {
        tSupervisorInfo.setCreateTime(DateUtils.getNowDate());
        return tSupervisorInfoMapper.insertTSupervisorInfo(tSupervisorInfo);
    }

    /**
     * 修改燃气督办
     * 
     * @param tSupervisorInfo 燃气督办
     * @return 结果
     */
    @Override
    public int updateTSupervisorInfo(TSupervisorInfo tSupervisorInfo)
    {
        return tSupervisorInfoMapper.updateTSupervisorInfo(tSupervisorInfo);
    }

    /**
     * 批量删除燃气督办
     * 
     * @param supervisorIds 需要删除的燃气督办ID
     * @return 结果
     */
    @Override
    public int deleteTSupervisorInfoByIds(Long[] supervisorIds)
    {
        return tSupervisorInfoMapper.deleteTSupervisorInfoByIds(supervisorIds);
    }

    /**
     * 删除燃气督办信息
     * 
     * @param supervisorId 燃气督办ID
     * @return 结果
     */
    @Override
    public int deleteTSupervisorInfoById(Long supervisorId)
    {
        return tSupervisorInfoMapper.deleteTSupervisorInfoById(supervisorId);
    }
}
