package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TSecurityDisseminateMapper;
import com.zehong.system.domain.TSecurityDisseminate;
import com.zehong.system.service.ITSecurityDisseminateService;

/**
 * 安全宣传Service业务层处理
 * 
 * @author zehong
 * @date 2024-04-22
 */
@Service
public class TSecurityDisseminateServiceImpl implements ITSecurityDisseminateService 
{
    @Autowired
    private TSecurityDisseminateMapper tSecurityDisseminateMapper;

    /**
     * 查询安全宣传
     * 
     * @param securityId 安全宣传ID
     * @return 安全宣传
     */
    @Override
    public TSecurityDisseminate selectTSecurityDisseminateById(Long securityId)
    {
        return tSecurityDisseminateMapper.selectTSecurityDisseminateById(securityId);
    }

    /**
     * 查询安全宣传列表
     * 
     * @param tSecurityDisseminate 安全宣传
     * @return 安全宣传
     */
    @Override
    public List<TSecurityDisseminate> selectTSecurityDisseminateList(TSecurityDisseminate tSecurityDisseminate)
    {
        return tSecurityDisseminateMapper.selectTSecurityDisseminateList(tSecurityDisseminate);
    }

    /**
     * 新增安全宣传
     * 
     * @param tSecurityDisseminate 安全宣传
     * @return 结果
     */
    @Override
    public int insertTSecurityDisseminate(TSecurityDisseminate tSecurityDisseminate)
    {
        tSecurityDisseminate.setCreateTime(DateUtils.getNowDate());
        return tSecurityDisseminateMapper.insertTSecurityDisseminate(tSecurityDisseminate);
    }

    /**
     * 修改安全宣传
     * 
     * @param tSecurityDisseminate 安全宣传
     * @return 结果
     */
    @Override
    public int updateTSecurityDisseminate(TSecurityDisseminate tSecurityDisseminate)
    {
        return tSecurityDisseminateMapper.updateTSecurityDisseminate(tSecurityDisseminate);
    }

    /**
     * 批量删除安全宣传
     * 
     * @param securityIds 需要删除的安全宣传ID
     * @return 结果
     */
    @Override
    public int deleteTSecurityDisseminateByIds(Long[] securityIds)
    {
        return tSecurityDisseminateMapper.deleteTSecurityDisseminateByIds(securityIds);
    }

    /**
     * 删除安全宣传信息
     * 
     * @param securityId 安全宣传ID
     * @return 结果
     */
    @Override
    public int deleteTSecurityDisseminateById(Long securityId)
    {
        return tSecurityDisseminateMapper.deleteTSecurityDisseminateById(securityId);
    }
}
