package com.zehong.system.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.zehong.common.core.domain.entity.SysRole;
import com.zehong.common.exception.CustomException;
import com.zehong.common.utils.GovernmentDataCopyUtil;
import com.zehong.common.utils.GovernmentDataUtil;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.common.utils.StringUtils;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.TConGasProInfor;
import com.zehong.system.domain.TRiskDevMajInfor;
import com.zehong.system.domain.vo.TRiskDevMajInfoVo;
import com.zehong.system.mapper.TRiskDevMajInforMapper;
import com.zehong.system.service.ITRiskDevMajInforService;
import com.zehong.system.service.ITSerialNumberInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 重要风险点管控Service业务层处理
 * 
 * @author zehong
 * @date 2024-07-01
 */
@Service
public class TRiskDevMajInforServiceImpl implements ITRiskDevMajInforService 
{
    private static final Logger log = LoggerFactory.getLogger(TRiskDevMajInforServiceImpl.class);

    @Resource
    private TRiskDevMajInforMapper tRiskDevMajInforMapper;

    @Resource
    private ITSerialNumberInfoService itSerialNumberInfoService;

    @Resource
    private GovernmentDataUtil governmentDataUtil;

    /**
     * 查询重要风险点管控
     * 
     * @param fRiskDevMajInforId 重要风险点管控ID
     * @return 重要风险点管控
     */
    @Override
    public TRiskDevMajInfor selectTRiskDevMajInforById(Long fRiskDevMajInforId)
    {
        return tRiskDevMajInforMapper.selectTRiskDevMajInforById(fRiskDevMajInforId);
    }

    /**
     * 查询重要风险点管控 - 详情使用
     *
     * @param fRiskDevMajInforId 重要风险点管控ID
     * @return 重要风险点管控
     */
    @Override
    public TRiskDevMajInfor selectTRiskDevMajInforByIdForDetail(Long fRiskDevMajInforId) {
        return tRiskDevMajInforMapper.selectTRiskDevMajInforByIdForDetail(fRiskDevMajInforId);
    }

    /**
     * 查询重要风险点管控列表
     * 
     * @param tRiskDevMajInfor 重要风险点管控
     * @return 重要风险点管控
     */
    @Override
    public List<TRiskDevMajInfor> selectTRiskDevMajInforList(TRiskDevMajInfor tRiskDevMajInfor)
    {
        SysRole sysRole = SecurityUtils.getLoginUser().getUser().getRoles().get(0);
        if (sysRole.getRoleId() == 3) {
            tRiskDevMajInfor.setEntUploadState("1");
        }

        return tRiskDevMajInforMapper.selectTRiskDevMajInforList(tRiskDevMajInfor);
    }

    /**
     * 查询重要风险点管控列表
     *
     * @param tRiskDevMajInfor 重要风险点管控 - 导出
     * @return 重要风险点管控
     */
    @Override
    public List<TRiskDevMajInfor> exportRiskDevMajInforList(TRiskDevMajInfor tRiskDevMajInfor)
    {
        SysRole sysRole = SecurityUtils.getLoginUser().getUser().getRoles().get(0);
        if (sysRole.getRoleId() == 3) {
            tRiskDevMajInfor.setEntUploadState("1");
        }

        if(sysRole.getRoleId()==3){
            ExcelUtil.hiddencolumns.add(11);
            ExcelUtil.hiddencolumns.add(12);
        } else {
            ExcelUtil.hiddencolumns.add(13);
            ExcelUtil.hiddencolumns.add(14);
        }

        return tRiskDevMajInforMapper.exportRiskDevMajInforList(tRiskDevMajInfor);
    }

    /**
     * 新增重要风险点管控
     * 
     * @param tRiskDevMajInfor 重要风险点管控
     * @return 结果
     */
    @Override
    public int insertTRiskDevMajInfor(TRiskDevMajInfor tRiskDevMajInfor)
    {
        Map<String,String> num = itSerialNumberInfoService.getSerialNumberByTableType("t_risk_dev_maj_infor");
        if(null == num || StringUtils.isEmpty(num.get("f_risk_code"))) throw new CustomException("重要风险点编码未配置！");
        tRiskDevMajInfor.setfRiskCode(tRiskDevMajInfor.getfCompanyId() + num.get("f_risk_code"));
        tRiskDevMajInfor.setfUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        return tRiskDevMajInforMapper.insertTRiskDevMajInfor(tRiskDevMajInfor);
    }

    /**
     * 修改重要风险点管控
     * 
     * @param tRiskDevMajInfor 重要风险点管控
     * @return 结果
     */
    @Override
    public int updateTRiskDevMajInfor(TRiskDevMajInfor tRiskDevMajInfor)
    {
        tRiskDevMajInfor.setfUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        return tRiskDevMajInforMapper.updateTRiskDevMajInfor(tRiskDevMajInfor);
    }

    /**
     * 批量删除重要风险点管控
     * 
     * @param fRiskDevMajInforIds 需要删除的重要风险点管控ID
     * @return 结果
     */
    @Override
    public int deleteTRiskDevMajInforByIds(Long[] fRiskDevMajInforIds)
    {
        return tRiskDevMajInforMapper.deleteTRiskDevMajInforByIds(fRiskDevMajInforIds);
    }

    /**
     * 删除重要风险点管控信息
     * 
     * @param fRiskDevMajInforId 重要风险点管控ID
     * @return 结果
     */
    @Override
    public int deleteTRiskDevMajInforById(Long fRiskDevMajInforId)
    {
        return tRiskDevMajInforMapper.deleteTRiskDevMajInforById(fRiskDevMajInforId);
    }

    /**
     * 上传重要风险点档案
     * @param fRiskDevMajInforId 重要风险点档案id
     * @return
     */
    @Override
    public int reportRiskInfo(Long fRiskDevMajInforId) throws Exception {
        TRiskDevMajInfor riskDevMajInfo = tRiskDevMajInforMapper.selectTRiskDevMajInforById(fRiskDevMajInforId);
        TRiskDevMajInfoVo riskDevMajInfoVo = new TRiskDevMajInfoVo();
        GovernmentDataCopyUtil.copyToGovernData(riskDevMajInfo,riskDevMajInfoVo);
        List<TRiskDevMajInfoVo> data = new ArrayList<>();
        data.add(riskDevMajInfoVo);
        JSONObject reportResult = governmentDataUtil.setInfo("risk/device/major/information","WRITE",data);
        log.info("上传重要风险点档案结果===================" + reportResult.toJSONString());
        if(!"0".equals(reportResult.getString("resultCode"))) throw new CustomException("上传重要风险点档案接口失败");
        riskDevMajInfo.setGovUploadState("1");
        riskDevMajInfo.setGovUploadTime(new Date());
        tRiskDevMajInforMapper.updateTRiskDevMajInfor(riskDevMajInfo);
        return 1;
    }

    /**
     * 企业端 上传重要风险点档案
     * @param fRiskDevMajInforId 重要风险点档案id
     * @return 1
     */
    @Override
    public int entReportRiskInfo(Long fRiskDevMajInforId) {
         tRiskDevMajInforMapper.entReportRiskDevMajInfor("1",new Date(),fRiskDevMajInforId);
         return 1;
    }
}
