package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TPatrolPositionMapper;
import com.zehong.system.domain.TPatrolPosition;
import com.zehong.system.service.ITPatrolPositionService;

/**
 * 巡检点Service业务层处理
 * 
 * @author zehong
 * @date 2023-08-05
 */
@Service
public class TPatrolPositionServiceImpl implements ITPatrolPositionService 
{
    @Autowired
    private TPatrolPositionMapper tPatrolPositionMapper;

    /**
     * 查询巡检点
     * 
     * @param patrolId 巡检点ID
     * @return 巡检点
     */
    @Override
    public TPatrolPosition selectTPatrolPositionById(Long patrolId)
    {
        return tPatrolPositionMapper.selectTPatrolPositionById(patrolId);
    }

    /**
     * 查询巡检点列表
     * 
     * @param tPatrolPosition 巡检点
     * @return 巡检点
     */
    @Override
    public List<TPatrolPosition> selectTPatrolPositionList(TPatrolPosition tPatrolPosition)
    {
        return tPatrolPositionMapper.selectTPatrolPositionList(tPatrolPosition);
    }

    /**
     * 新增巡检点
     * 
     * @param tPatrolPosition 巡检点
     * @return 结果
     */
    @Override
    public int insertTPatrolPosition(TPatrolPosition tPatrolPosition)
    {
        tPatrolPosition.setCreateTime(DateUtils.getNowDate());
        return tPatrolPositionMapper.insertTPatrolPosition(tPatrolPosition);
    }

    /**
     * 修改巡检点
     * 
     * @param tPatrolPosition 巡检点
     * @return 结果
     */
    @Override
    public int updateTPatrolPosition(TPatrolPosition tPatrolPosition)
    {
        tPatrolPosition.setUpdateTime(DateUtils.getNowDate());
        return tPatrolPositionMapper.updateTPatrolPosition(tPatrolPosition);
    }

    /**
     * 批量删除巡检点
     * 
     * @param patrolIds 需要删除的巡检点ID
     * @return 结果
     */
    @Override
    public int deleteTPatrolPositionByIds(Long[] patrolIds)
    {
        return tPatrolPositionMapper.deleteTPatrolPositionByIds(patrolIds);
    }

    /**
     * 删除巡检点信息
     * 
     * @param patrolId 巡检点ID
     * @return 结果
     */
    @Override
    public int deleteTPatrolPositionById(Long patrolId)
    {
        return tPatrolPositionMapper.deleteTPatrolPositionById(patrolId);
    }
}
