package com.zehong.system.service.impl;

import java.sql.SQLIntegrityConstraintViolationException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import com.zehong.common.exception.CustomException;
import com.zehong.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TInsSpotHazardRefMapper;
import com.zehong.system.domain.TInsSpotHazardRef;
import com.zehong.system.service.ITInsSpotHazardRefService;

/**
 * 监督检查-抽查隐患Service业务层处理
 * 
 * @author zehong
 * @date 2024-05-21
 */
@Service
public class TInsSpotHazardRefServiceImpl implements ITInsSpotHazardRefService 
{
    @Autowired
    private TInsSpotHazardRefMapper tInsSpotHazardRefMapper;

    /**
     * 查询监督检查-抽查隐患
     * 
     * @param fInsSpotHazardRefId 监督检查-抽查隐患ID
     * @return 监督检查-抽查隐患
     */
    @Override
    public TInsSpotHazardRef selectTInsSpotHazardRefById(Long fInsSpotHazardRefId)
    {
        return tInsSpotHazardRefMapper.selectTInsSpotHazardRefById(fInsSpotHazardRefId);
    }

    /**
     * 查询监督检查-抽查隐患列表
     * 
     * @param tInsSpotHazardRef 监督检查-抽查隐患
     * @return 监督检查-抽查隐患
     */
    @Override
    public List<TInsSpotHazardRef> selectTInsSpotHazardRefList(TInsSpotHazardRef tInsSpotHazardRef)
    {
        return tInsSpotHazardRefMapper.selectTInsSpotHazardRefList(tInsSpotHazardRef);
    }

    /**
     * 新增监督检查-抽查隐患
     * 
     * @param tInsSpotHazardRef 监督检查-抽查隐患
     * @return 结果
     */
    @Override
    public int insertTInsSpotHazardRef(TInsSpotHazardRef tInsSpotHazardRef)
    {

        try{
            tInsSpotHazardRef.setfLastTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            return tInsSpotHazardRefMapper.insertTInsSpotHazardRef(tInsSpotHazardRef);
        }catch (Exception  e){
            Throwable cause = e.getCause();
            if (cause instanceof SQLIntegrityConstraintViolationException){
                String errMsg = cause.getMessage();
                if (StringUtils.isNotEmpty(errMsg) && errMsg.contains("index_hazard_unique_code")){
                    throw new CustomException("隐患唯一编码不唯一");
                }
            }
            return 0;
        }
    }

    /**
     * 修改监督检查-抽查隐患
     * 
     * @param tInsSpotHazardRef 监督检查-抽查隐患
     * @return 结果
     */
    @Override
    public int updateTInsSpotHazardRef(TInsSpotHazardRef tInsSpotHazardRef)
    {
        try{
            tInsSpotHazardRef.setfLastTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            return tInsSpotHazardRefMapper.updateTInsSpotHazardRef(tInsSpotHazardRef);
        }catch (Exception  e){
            Throwable cause = e.getCause();
            if (cause instanceof SQLIntegrityConstraintViolationException){
                String errMsg = cause.getMessage();
                if (StringUtils.isNotEmpty(errMsg) && errMsg.contains("index_hazard_unique_code")){
                    throw new CustomException("隐患唯一编码不唯一");
                }
            }
            return 0;
        }
    }

    /**
     * 抽查隐患-处置
     * @param tInsSpotHazardRef t
     * @return
     */
    @Override
    public int disposeOfInsSpotHazardRef(TInsSpotHazardRef tInsSpotHazardRef) {
        tInsSpotHazardRef.setDisposalTime(new Date());
        return tInsSpotHazardRefMapper.disposeOfInsSpotHazardRef(tInsSpotHazardRef);
    }

    /**
     * 批量删除监督检查-抽查隐患
     * 
     * @param fInsSpotHazardRefIds 需要删除的监督检查-抽查隐患ID
     * @return 结果
     */
    @Override
    public int deleteTInsSpotHazardRefByIds(Long[] fInsSpotHazardRefIds)
    {
        return tInsSpotHazardRefMapper.deleteTInsSpotHazardRefByIds(fInsSpotHazardRefIds);
    }

    /**
     * 删除监督检查-抽查隐患信息
     * 
     * @param fInsSpotHazardRefId 监督检查-抽查隐患ID
     * @return 结果
     */
    @Override
    public int deleteTInsSpotHazardRefById(Long fInsSpotHazardRefId)
    {
        return tInsSpotHazardRefMapper.deleteTInsSpotHazardRefById(fInsSpotHazardRefId);
    }
}
