package com.zehong.system.service.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import com.zehong.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TInsScopeInforMapper;
import com.zehong.system.domain.TInsScopeInfor;
import com.zehong.system.service.ITInsScopeInforService;

/**
 * 监督检查-检查范围Service业务层处理
 * 
 * @author zehong
 * @date 2024-05-16
 */
@Service
public class TInsScopeInforServiceImpl implements ITInsScopeInforService 
{
    @Autowired
    private TInsScopeInforMapper tInsScopeInforMapper;

    /**
     * 查询监督检查-检查范围
     * 
     * @param fScopeInforId 监督检查-检查范围ID
     * @return 监督检查-检查范围
     */
    @Override
    public TInsScopeInfor selectTInsScopeInforById(Long fScopeInforId)
    {
        return tInsScopeInforMapper.selectTInsScopeInforById(fScopeInforId);
    }

    /**
     * 查询监督检查-检查范围列表
     * 
     * @param tInsScopeInfor 监督检查-检查范围
     * @return 监督检查-检查范围
     */
    @Override
    public List<TInsScopeInfor> selectTInsScopeInforList(TInsScopeInfor tInsScopeInfor)
    {
        return tInsScopeInforMapper.selectTInsScopeInforList(tInsScopeInfor);
    }

    /**
     * 新增监督检查-检查范围
     * 
     * @param tInsScopeInfor 监督检查-检查范围
     * @return 结果
     */
    @Override
    public int insertTInsScopeInfor(TInsScopeInfor tInsScopeInfor)
    {
        tInsScopeInfor.setfCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        tInsScopeInfor.setfCreateBy(SecurityUtils.getUsername());
        return tInsScopeInforMapper.insertTInsScopeInfor(tInsScopeInfor);
    }

    /**
     * 修改监督检查-检查范围
     * 
     * @param tInsScopeInfor 监督检查-检查范围
     * @return 结果
     */
    @Override
    public int updateTInsScopeInfor(TInsScopeInfor tInsScopeInfor)
    {
        tInsScopeInfor.setfUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        tInsScopeInfor.setfModifyBy(SecurityUtils.getUsername());
        return tInsScopeInforMapper.updateTInsScopeInfor(tInsScopeInfor);
    }

    /**
     * 批量删除监督检查-检查范围
     * 
     * @param fScopeInforIds 需要删除的监督检查-检查范围ID
     * @return 结果
     */
    @Override
    public int deleteTInsScopeInforByIds(Long[] fScopeInforIds)
    {
        return tInsScopeInforMapper.deleteTInsScopeInforByIds(fScopeInforIds);
    }

    /**
     * 删除监督检查-检查范围信息
     * 
     * @param fScopeInforId 监督检查-检查范围ID
     * @return 结果
     */
    @Override
    public int deleteTInsScopeInforById(Long fScopeInforId)
    {
        return tInsScopeInforMapper.deleteTInsScopeInforById(fScopeInforId);
    }
}
