package com.zehong.system.service.impl;

import java.sql.SQLIntegrityConstraintViolationException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import com.zehong.common.exception.CustomException;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TInsInsListInforMapper;
import com.zehong.system.domain.TInsInsListInfor;
import com.zehong.system.service.ITInsInsListInforService;

/**
 * 监督检查-获取检查项Service业务层处理
 * 
 * @author zehong
 * @date 2024-05-17
 */
@Service
public class TInsInsListInforServiceImpl implements ITInsInsListInforService 
{
    @Autowired
    private TInsInsListInforMapper tInsInsListInforMapper;

    /**
     * 查询监督检查-获取检查项
     * 
     * @param fInsInsListInforId 监督检查-获取检查项ID
     * @return 监督检查-获取检查项
     */
    @Override
    public TInsInsListInfor selectTInsInsListInforById(Long fInsInsListInforId)
    {
        return tInsInsListInforMapper.selectTInsInsListInforById(fInsInsListInforId);
    }

    /**
     * 查询监督检查-获取检查项列表
     * 
     * @param tInsInsListInfor 监督检查-获取检查项
     * @return 监督检查-获取检查项
     */
    @Override
    public List<TInsInsListInfor> selectTInsInsListInforList(TInsInsListInfor tInsInsListInfor)
    {
        return tInsInsListInforMapper.selectTInsInsListInforList(tInsInsListInfor);
    }

    /**
     * 新增监督检查-获取检查项
     * 
     * @param tInsInsListInfor 监督检查-获取检查项
     * @return 结果
     */
    @Override
    public int insertTInsInsListInfor(TInsInsListInfor tInsInsListInfor){
        try{
            tInsInsListInfor.setfCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            tInsInsListInfor.setfCreateBy(SecurityUtils.getUsername());
            return tInsInsListInforMapper.insertTInsInsListInfor(tInsInsListInfor);
        }catch (Exception e){
            Throwable cause = e.getCause();
            if (cause instanceof SQLIntegrityConstraintViolationException){
                String errMsg = cause.getMessage();
                if (StringUtils.isNotEmpty(errMsg) && errMsg.contains("index_unique_code")){
                    throw new CustomException("检查项唯一编码不唯一");
                }
            }
            return 0;
        }
    }

    /**
     * 修改监督检查-获取检查项
     * 
     * @param tInsInsListInfor 监督检查-获取检查项
     * @return 结果
     */
    @Override
    public int updateTInsInsListInfor(TInsInsListInfor tInsInsListInfor)
    {
        try{
            tInsInsListInfor.setfUpdateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            tInsInsListInfor.setfUpdateBy(SecurityUtils.getUsername());
            return tInsInsListInforMapper.updateTInsInsListInfor(tInsInsListInfor);
        }catch (Exception e){
            Throwable cause = e.getCause();
            if (cause instanceof SQLIntegrityConstraintViolationException){
                String errMsg = cause.getMessage();
                if (StringUtils.isNotEmpty(errMsg) && errMsg.contains("index_unique_code")){
                    throw new CustomException("检查项唯一编码不唯一");
                }
            }
            return 0;
        }
    }

    /**
     * 批量删除监督检查-获取检查项
     * 
     * @param fInsInsListInforIds 需要删除的监督检查-获取检查项ID
     * @return 结果
     */
    @Override
    public int deleteTInsInsListInforByIds(Long[] fInsInsListInforIds)
    {
        return tInsInsListInforMapper.deleteTInsInsListInforByIds(fInsInsListInforIds);
    }

    /**
     * 删除监督检查-获取检查项信息
     * 
     * @param fInsInsListInforId 监督检查-获取检查项ID
     * @return 结果
     */
    @Override
    public int deleteTInsInsListInforById(Long fInsInsListInforId)
    {
        return tInsInsListInforMapper.deleteTInsInsListInforById(fInsInsListInforId);
    }
}
