package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TDeviceUserMapper;
import com.zehong.system.domain.TDeviceUser;
import com.zehong.system.service.ITDeviceUserService;

/**
 * 设备用户Service业务层处理
 * 
 * @author zehong
 * @date 2023-07-23
 */
@Service
public class TDeviceUserServiceImpl implements ITDeviceUserService 
{
    @Autowired
    private TDeviceUserMapper tDeviceUserMapper;

    /**
     * 查询设备用户
     * 
     * @param userId 设备用户ID
     * @return 设备用户
     */
    @Override
    public TDeviceUser selectTDeviceUserById(Long userId)
    {
        return tDeviceUserMapper.selectTDeviceUserById(userId);
    }
    @Override
    public TDeviceUser selectTDeviceUserByCode(String code)
    {
        return tDeviceUserMapper.selectTDeviceUserByCode(code);
    }


    /**
     * 查询设备用户列表
     * 
     * @param tDeviceUser 设备用户
     * @return 设备用户
     */
    @Override
    public List<TDeviceUser> selectTDeviceUserList(TDeviceUser tDeviceUser)
    {
        return tDeviceUserMapper.selectTDeviceUserList(tDeviceUser);
    }
    @Override
    public List<TDeviceUser> allListbyTownship()
    {
        return tDeviceUserMapper.allListbyTownship();
    }

    /**
     * 新增设备用户
     * 
     * @param tDeviceUser 设备用户
     * @return 结果
     */
    @Override
    public int insertTDeviceUser(TDeviceUser tDeviceUser)
    {
        tDeviceUser.setCreateTime(DateUtils.getNowDate());
        return tDeviceUserMapper.insertTDeviceUser(tDeviceUser);
    }

    /**
     * 修改设备用户
     * 
     * @param tDeviceUser 设备用户
     * @return 结果
     */
    @Override
    public int updateTDeviceUser(TDeviceUser tDeviceUser)
    {
        tDeviceUser.setUpdateTime(DateUtils.getNowDate());
        return tDeviceUserMapper.updateTDeviceUser(tDeviceUser);
    }

    /**
     * 批量删除设备用户
     * 
     * @param userIds 需要删除的设备用户ID
     * @return 结果
     */
    @Override
    public int deleteTDeviceUserByIds(Long[] userIds)
    {
        return tDeviceUserMapper.deleteTDeviceUserByIds(userIds);
    }

    /**
     * 删除设备用户信息
     * 
     * @param userId 设备用户ID
     * @return 结果
     */
    @Override
    public int deleteTDeviceUserById(Long userId)
    {
        return tDeviceUserMapper.deleteTDeviceUserById(userId);
    }
}
