package com.zehong.system.service.impl;

import com.zehong.system.domain.TComplainDealManSysSet;
import com.zehong.system.mapper.TComplainDealManSysSetMapper;
import com.zehong.system.service.ITComplainDealManSysSetService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 燃气投诉处置的管理制度维护Service业务层处理
 * 
 * @author zehong
 * @date 2024-06-05
 */
@Service
public class TComplainDealManSysSetServiceImpl implements ITComplainDealManSysSetService 
{
    @Autowired
    private TComplainDealManSysSetMapper tComplainDealManSysSetMapper;

    /**
     * 查询燃气投诉处置的管理制度维护
     * 
     * @param fComplainDealManSysSetId 燃气投诉处置的管理制度维护ID
     * @return 燃气投诉处置的管理制度维护
     */
    @Override
    public TComplainDealManSysSet selectTComplainDealManSysSetById(Long fComplainDealManSysSetId)
    {
        return tComplainDealManSysSetMapper.selectTComplainDealManSysSetById(fComplainDealManSysSetId);
    }

    /**
     * 查询燃气投诉处置的管理制度维护列表
     * 
     * @param tComplainDealManSysSet 燃气投诉处置的管理制度维护
     * @return 燃气投诉处置的管理制度维护
     */
    @Override
    public List<TComplainDealManSysSet> selectTComplainDealManSysSetList(TComplainDealManSysSet tComplainDealManSysSet)
    {
        return tComplainDealManSysSetMapper.selectTComplainDealManSysSetList(tComplainDealManSysSet);
    }

    /**
     * 批量修改
     * @param tComplainDealManSysSets s
     */
    @Override
    public void batchUpdate(List<TComplainDealManSysSet> tComplainDealManSysSets) {
        tComplainDealManSysSetMapper.batchUpdate(tComplainDealManSysSets);
    }

    /**
     * 新增燃气投诉处置的管理制度维护
     * 
     * @param tComplainDealManSysSet 燃气投诉处置的管理制度维护
     * @return 结果
     */
    @Override
    public int insertTComplainDealManSysSet(TComplainDealManSysSet tComplainDealManSysSet)
    {
        return tComplainDealManSysSetMapper.insertTComplainDealManSysSet(tComplainDealManSysSet);
    }

    /**
     * 修改燃气投诉处置的管理制度维护
     * 
     * @param tComplainDealManSysSet 燃气投诉处置的管理制度维护
     * @return 结果
     */
    @Override
    public int updateTComplainDealManSysSet(TComplainDealManSysSet tComplainDealManSysSet)
    {
        return tComplainDealManSysSetMapper.updateTComplainDealManSysSet(tComplainDealManSysSet);
    }

    /**
     * 批量删除燃气投诉处置的管理制度维护
     * 
     * @param fComplainDealManSysSetIds 需要删除的燃气投诉处置的管理制度维护ID
     * @return 结果
     */
    @Override
    public int deleteTComplainDealManSysSetByIds(Long[] fComplainDealManSysSetIds)
    {
        return tComplainDealManSysSetMapper.deleteTComplainDealManSysSetByIds(fComplainDealManSysSetIds);
    }

    /**
     * 删除燃气投诉处置的管理制度维护信息
     * 
     * @param fComplainDealManSysSetId 燃气投诉处置的管理制度维护ID
     * @return 结果
     */
    @Override
    public int deleteTComplainDealManSysSetById(Long fComplainDealManSysSetId)
    {
        return tComplainDealManSysSetMapper.deleteTComplainDealManSysSetById(fComplainDealManSysSetId);
    }
}
