package com.zehong.system.service.impl;

import com.zehong.common.core.domain.entity.SysDictData;
import com.zehong.system.domain.TCountyLevelRegion;
import com.zehong.system.mapper.TCityLevelRegionMapper;
import com.zehong.system.mapper.TCountyLevelRegionMapper;
import com.zehong.system.service.IDistrictPlanningService;
import com.zehong.system.service.ISysDictDataService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * @Author: zehong
 * @Date: 2024/7/1 17:44
 */
@Service
public class DistrictPlanningServiceImpl implements IDistrictPlanningService {

    @Resource
    private TCityLevelRegionMapper cityLevelRegionMapper;

    @Resource
    private TCountyLevelRegionMapper countyLevelRegionMapper;

    @Resource
    private ISysDictDataService sysDictDataService;


    /**
     * 根据配置的 市查询  县-区数据 city_under_admin_plan city_code
     * @return r
     */
    @Override
    public  List<TCountyLevelRegion> listCountyByDict() {
        SysDictData city_code = sysDictDataService.selectByLable("city_code");
        String dictValue = city_code.getDictValue();
        return countyLevelRegionMapper.queryByCityId(dictValue);
    }
}
