package com.zehong.system.service;

import java.util.List;

import com.zehong.system.domain.TDetectorUser;
import com.zehong.system.domain.TYehuaqiUser;
import com.zehong.system.domain.TYehuaqiuserSafetyDeviceInfo;
import com.zehong.system.domain.vo.*;

/**
 * 燃气用户Service接口
 * 
 * @author zehong
 * @date 2022-09-14
 */
public interface ITYehuaqiUserService 
{
    /**
     * 查询燃气用户
     * 
     * @param userId 燃气用户ID
     * @return 燃气用户
     */
    public TYehuaqiUser selectTYehuaqiUserById(Long userId);

    /**
     * 查询燃气用户列表
     * 
     * @param tYehuaqiUser 燃气用户
     * @return 燃气用户集合
     */
    public List<TYehuaqiUser> selectTYehuaqiUserList(TYehuaqiUser tYehuaqiUser);

    public List<TYehuaqiUser> selectAllUserList(TYehuaqiUser tYehuaqiUser);

    /**
     * 根据 userOwnId list 和 enterpriseId 查询数据
     * @param userOwnIds userOwnId list
     * @param enterpriseId enterpriseId
     * @return r
     */
    public List<TYehuaqiUser> queryByUserOwnIdAndEnterpriseIdForThirdParty(List<String> userOwnIds,String enterpriseId);

    /**
     * 根据企业id统计错误数据
     * @return r
     */
    public int countByBeyondEnterpriseId();


    /**
     * 处理 解析好的 多sheet 导入的数据
     * @param gasUserExportVos g
     * @param safetyDeviceExportVos s
     */
    public void handleCustomMoreSheetImportData(List<UserManageGasUserExportVo> gasUserExportVos,
                                                List<YeHuaqiUserManageSafetyDeviceExportVo> safetyDeviceExportVos,
                                                boolean updateSupport ,boolean reImportOfIncorrectDataFlag) ;


    /**
     * 查询燃气用户列表 - 导出使用
     *
     * @param tDetectorUser 燃气用户
     * @return 燃气用户集合
     */
    public List<TYehuaqiUser> selectForExportTYehuaqiUserList(TYehuaqiUser tDetectorUser);

    /**
     * 根据用户自有id 集合 和 企业id 查询数据
     * @param userOwnIds u
     * @param enterpriseId e
     * @return r
     */
    public List<TYehuaqiUser> queryByUserOwnIdsAndEnterpriseId(List<String> userOwnIds,String enterpriseId);

    /**
     * 批量插入 安全装置
     * @param yehuaqiuserSafetyDeviceInfos y
     * @return r
     */
    public int insertBatchSafetyDevice(List<TYehuaqiuserSafetyDeviceInfo> yehuaqiuserSafetyDeviceInfos);

    /**
     * 根据 userId 集合批量删除
     * @param userIds u
     * @return r
     */
    public int deleteBatchSafetyDeviceByUserIds(List<Long> userIds);

    /**
     * 查询导入的错误数据
     * @return r
     */
    public List<TYehuaqiUser> queryErrorDetectorUserList();

    /**
     * 新增燃气用户
     * 
     * @param tYehuaqiUser 燃气用户
     * @return 结果
     */
    public int insertTYehuaqiUser(TYehuaqiUser tYehuaqiUser);

    /**
     * 批量插入
     * @param tYehuaqiUsers t
     * @return r
     */
    public int insertBatch(List<TYehuaqiUser> tYehuaqiUsers);

    /**
     * 提供给第三方接口调用时的批量插入
     * @param tYehuaqiUsers r
     * @return r
     */
    public int insertBatchForThirdParty(List<TYehuaqiUser> tYehuaqiUsers);
    /**
     * 修改燃气用户
     * 
     * @param tYehuaqiUser 燃气用户
     * @return 结果
     */
    public int updateTYehuaqiUser(TYehuaqiUser tYehuaqiUser);

    /**
     * 批量修改
     * @param tYehuaqiUsers t
     * @return r
     */
    public int updateBatch(List<TYehuaqiUser> tYehuaqiUsers);

    /**
     * 批量删除燃气用户
     * 
     * @param userIds 需要删除的燃气用户ID
     * @return 结果
     */
    public int deleteTYehuaqiUserByIds(Long[] userIds);

    /**
     * 删除燃气用户信息
     * 
     * @param userId 燃气用户ID
     * @return 结果
     */
    public int deleteTYehuaqiUserById(Long userId);


    /**
     * 新增燃气用户和安全装置
     * @param gasUserAndSafetyDeviceVo gas
     * @return r
     */
    public int addUserAndSafetyDevice(GasUserAndSafetyDeviceVo gasUserAndSafetyDeviceVo);

    /**
     * 修改燃气用户和安全装置
     * @param gasUserAndSafetyDeviceVo gas
     * @return r
     */
    public int updateUserAndSafetyDevice(GasUserAndSafetyDeviceVo gasUserAndSafetyDeviceVo);
}
