package com.zehong.system.service;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.Statistics;
import com.zehong.system.domain.TTroubleStandingBook;
import com.zehong.system.domain.form.TTroubleStandingBookForm;
import com.zehong.system.domain.vo.TTroubleStandingBookVo;

/**
 * 事故台账Service接口
 *
 * @author zehong
 * @date 2022-02-09
 */
public interface ITTroubleStandingBookService
{
    /**
     * 查询事故台账
     *
     * @param troubleId 事故台账ID
     * @return 事故台账
     */
    public TTroubleStandingBook selectTTroubleStandingBookById(Long troubleId);

    /**
     * 查询事故台账列表
     *
     * @param tTroubleStandingBook 事故台账
     * @return 事故台账集合
     */
    public List<TTroubleStandingBook> selectTTroubleStandingBookList(TTroubleStandingBookForm tTroubleStandingBook);

    /**
     * 事故台账统计
     *
     * @return 事故台账统计
     */
    public TTroubleStandingBookVo selectTTroubleStandingBookStatistic();

    /**
     * 新增事故台账
     *
     * @param tTroubleStandingBook 事故台账
     * @return 结果
     */
    public int insertTTroubleStandingBook(TTroubleStandingBook tTroubleStandingBook);

    /**
     * 修改事故台账
     *
     * @param tTroubleStandingBook 事故台账
     * @return 结果
     */
    public int updateTTroubleStandingBook(TTroubleStandingBook tTroubleStandingBook);

    /**
     * 批量删除事故台账
     *
     * @param troubleIds 需要删除的事故台账ID
     * @return 结果
     */
    public int deleteTTroubleStandingBookByIds(Long[] troubleIds);

    /**
     * 删除事故台账信息
     *
     * @param troubleId 事故台账ID
     * @return 结果
     */
    public int deleteTTroubleStandingBookById(Long troubleId);


    /**
     * 查询统计信息
     * @return
     */
    List<Statistics> accidentLedger(List<String> sevenDate);
    /**
     * 统计每个月事故数量
     * @return
     */
    List<Map<String,Object>> selectTrobleCountByMonth();
    /**
     * 统计每年事故数量
     * @return
     */
    List<Map<String,Object>> selectTrobleCountByYear();
    /**
     * 统计乡镇事故数量
     * @return
     */
    List<Map<String,Object>> selectTrobleRanking();
    /**
     * 根据事故原因统计数量
     * @return
     */
    List<Map<String,Object>> selectTrobleReason();


}
