package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TInsSpotRecInfor;

/**
 * 监督检查-调查结果Service接口
 * 
 * @author zehong
 * @date 2024-05-22
 */
public interface ITInsSpotRecInforService 
{
    /**
     * 查询监督检查-调查结果
     * 
     * @param fInsSpotRecInforId 监督检查-调查结果ID
     * @return 监督检查-调查结果
     */
    public TInsSpotRecInfor selectTInsSpotRecInforById(Long fInsSpotRecInforId);

    /**
     * 查询监督检查-调查结果列表
     * 
     * @param tInsSpotRecInfor 监督检查-调查结果
     * @return 监督检查-调查结果集合
     */
    public List<TInsSpotRecInfor> selectTInsSpotRecInforList(TInsSpotRecInfor tInsSpotRecInfor);

    /**
     * 新增监督检查-调查结果
     * 
     * @param tInsSpotRecInfor 监督检查-调查结果
     * @return 结果
     */
    public int insertTInsSpotRecInfor(TInsSpotRecInfor tInsSpotRecInfor);

    /**
     * 修改监督检查-调查结果
     * 
     * @param tInsSpotRecInfor 监督检查-调查结果
     * @return 结果
     */
    public int updateTInsSpotRecInfor(TInsSpotRecInfor tInsSpotRecInfor);

    /**
     * 批量删除监督检查-调查结果
     * 
     * @param fInsSpotRecInforIds 需要删除的监督检查-调查结果ID
     * @return 结果
     */
    public int deleteTInsSpotRecInforByIds(Long[] fInsSpotRecInforIds);

    /**
     * 删除监督检查-调查结果信息
     * 
     * @param fInsSpotRecInforId 监督检查-调查结果ID
     * @return 结果
     */
    public int deleteTInsSpotRecInforById(Long fInsSpotRecInforId);

    /**
     * 上传调查结果
     * @param fInsSpotRecInforId 调查结果id
     * @return
     */
    int reportSpotRecInfo(Long fInsSpotRecInforId) throws Exception;
}
