package com.zehong.system.service;

import com.zehong.system.domain.BottleStatistics;
import com.zehong.system.domain.TGasBottleInfo;

import java.util.List;

/**
 * 气瓶信息Service接口
 *
 * @author zehong
 * @date 2023-08-15
 */
public interface ITGasBottleInfoService
{
    /**
     * 查询气瓶信息
     *
     * @param bottleId 气瓶信息ID
     * @return 气瓶信息
     */
    public TGasBottleInfo selectTGasBottleInfoById(Long bottleId);

    /**
     * 查询气瓶信息列表
     *
     * @param tGasBottleInfo 气瓶信息
     * @return 气瓶信息集合
     */
    public List<TGasBottleInfo> selectTGasBottleInfoList(TGasBottleInfo tGasBottleInfo);

    /**
     * 新增气瓶信息
     *
     * @param tGasBottleInfo 气瓶信息
     * @return 结果
     */
    public int insertTGasBottleInfo(TGasBottleInfo tGasBottleInfo);

    /**
     * 修改气瓶信息
     *
     * @param tGasBottleInfo 气瓶信息
     * @return 结果
     */
    public int updateTGasBottleInfo(TGasBottleInfo tGasBottleInfo);

    /**
     * 批量删除气瓶信息
     *
     * @param bottleIds 需要删除的气瓶信息ID
     * @return 结果
     */
    public int deleteTGasBottleInfoByIds(Long[] bottleIds);

    /**
     * 删除气瓶信息信息
     *
     * @param bottleId 气瓶信息ID
     * @return 结果
     */
    public int deleteTGasBottleInfoById(Long bottleId);

    /**
     * 气瓶数据导出
     * @param tGasBottleInfoList 气瓶实体
     * @param isUpdateSupport 是否更新
     * @return
     */
    String importTGasBottleInfo(List<TGasBottleInfo> tGasBottleInfoList, Boolean isUpdateSupport);

    /**
     * 气瓶统计
     * @param stationId 储配站id
     * @return
     */
    List<BottleStatistics> bottleStatistics(Long stationId);

    /**
     * 查询气瓶详细信息
     * @param bottleId
     */
    TGasBottleInfo getInf(String bottleId);

    TGasBottleInfo getInfn(String bottleId);
}
