package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TEventHandle;

/**
 * 事件处置Service接口
 * 
 * @author zehong
 * @date 2022-03-19
 */
public interface ITEventHandleService 
{
    /**
     * 查询事件处置
     * 
     * @param handleId 事件处置ID
     * @return 事件处置
     */
    public TEventHandle selectTEventHandleById(Long handleId);

    /**
     * 查询事件处置列表
     * 
     * @param tEventHandle 事件处置
     * @return 事件处置集合
     */
    public List<TEventHandle> selectTEventHandleList(TEventHandle tEventHandle);

    /**
     * 新增事件处置
     * 
     * @param tEventHandle 事件处置
     * @return 结果
     */
    public int insertTEventHandle(TEventHandle tEventHandle);

    /**
     * 修改事件处置
     * 
     * @param tEventHandle 事件处置
     * @return 结果
     */
    public int updateTEventHandle(TEventHandle tEventHandle);

    /**
     * 批量删除事件处置
     * 
     * @param handleIds 需要删除的事件处置ID
     * @return 结果
     */
    public int deleteTEventHandleByIds(Long[] handleIds);

    /**
     * 删除事件处置信息
     * 
     * @param handleId 事件处置ID
     * @return 结果
     */
    public int deleteTEventHandleById(Long handleId);
}
