package com.zehong.system.service;

import com.zehong.common.core.page.TableDataInfo;
import com.zehong.system.domain.TDetectorUser;
import com.zehong.system.domain.TDetectorUserCount;
import com.zehong.system.domain.TGasuserSafetyDeviceInfo;
import com.zehong.system.domain.TYehuaqiuserSafetyDeviceInfo;
import com.zehong.system.domain.vo.*;
import org.apache.ibatis.annotations.Param;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 燃气用户Service接口
 *
 * @author zehong
 * @date 2022-02-07
 */
public interface ITDetectorUserService
{


    /**
     * 查询探测器用户列表 地图使用 LabelMarker 标注的方式
     * @param tDetectorUser tDetectorUser
     * @return r
     */
    public  List<TDetectorUserVO> massMarksDetectorUserList(TDetectorUser tDetectorUser);

    /**
     * 查询探测器用户列表 地图使用 labelsLayerMarks 标注的方式
     * @param tDetectorUser tDetectorUser
     * @return r
     */
    Map<String, List<TDetectorUserVO>> labelsLayerMarksDetectorUserList(TDetectorUser tDetectorUser);

    /**
     * 查询探测器用户列表 地图使用 labelsLayer 标注的方式 带有村 和 安全装置数据
     * @param tDetectorUser tDetectorUser
     * @return r
     */
    Map<Object,List<Map<String,Object>>> labelsLayerMarksDUserVillageSafDevInfoMap(TDetectorUser tDetectorUser);


    /**
     * 获取探测器用户列表 大屏地图 labelsLayer 标注的方式 分页查询 居民用户
     * @param tDetectorUser t
     * @return r
     */
    TableDataInfo pageQueryLabelsLayerMarksDUser(TDetectorUser tDetectorUser);

    /**
     * 根据气瓶条码 查询 详情和追溯信息
     * @param code r
     * @return r
     */
    LpgGasBottleFilesBackToVo getLpgGasBottleFilesBackToByCode(String code);

    /**
     * 查询探测器用户列表
     *
     * @return 探测器用户集合
     */
    public List<TDetectorUserVO> detectorUserList(TDetectorUser tDetectorUser);

    /**
     * 查询探测器报警用户（前台调用）
     *
     * @return 探测器用户
     */
    public List<Map> getDetectorUserAlarmList();

    /**
     * 查询探测器报警用户（后台推送）
     *
     * @param tDetectorUser 探测器用户
     * @return 探测器用户
     */
    public List<TDetectorUserVO> detectorUserAlarmList(TDetectorUser tDetectorUser);

    /**
     * 泽宏云推送查询燃气用户
     *
     * @param tDetectorUser 燃气用户
     * @return 燃气用户
     */
    public List<TDetectorUser> selectTDetectorUser(TDetectorUser tDetectorUser);

    /**
     * 查询燃气用户
     *
     * @param userId 燃气用户ID
     * @return 燃气用户
     */
    public TDetectorUser selectTDetectorUserById(Long userId);

    /**
     * 查询燃气用户列表
     *
     * @param tDetectorUser 燃气用户
     * @return 燃气用户集合
     */
    public List<TDetectorUser> selectTDetectorUserList(TDetectorUser tDetectorUser);

    /**
     * 查询导入的错误数据
     * @return r
     */
    public List<TDetectorUser> queryErrorDetectorUserList(String gasType);

    /**
     * 根据 userOwnId list 和 enterpriseId 查询数据
     * @param userOwnIds userOwnId list
     * @param enterpriseId enterpriseId
     * @return r
     */
    public List<TDetectorUser> queryByUserOwnIdAndEnterpriseIdForThirdParty(List<String> userOwnIds,String enterpriseId);

    /**
     * 根据用户自有id 集合 和 企业id 查询数据
     * @param userOwnIds u
     * @param enterpriseId e
     * @return r
     */
    public List<TDetectorUser> queryByUserOwnIdsAndEnterpriseId(List<String> userOwnIds, String enterpriseId);
    /**
     * 查询燃气用户列表
     *
     * @param tDetectorUser 燃气用户
     * @return 燃气用户集合
     */
    public List<TDetectorUser> newSelectTDetectorUserList(TDetectorUser tDetectorUser);

    /**
     * 查询燃气用户列表 - 导出使用
     * @param tDetectorUser t
     * @return r
     */
    public List<TDetectorUser> selectForExportTDetectorUserList(TDetectorUser tDetectorUser);


    public List<TDetectorUser> selectTDetectorListstatus(TDetectorUser tDetectorUser);

    /**
     * 新增燃气用户
     *
     * @param tDetectorUser 燃气用户
     * @return 结果
     */
    public int insertTDetectorUser(TDetectorUser tDetectorUser);

    /**
     * 批量插入 安全装置
     * @param gasuserSafetyDeviceInfoList y
     * @return r
     */
    public int insertBatchSafetyDevice(List<TGasuserSafetyDeviceInfo> gasuserSafetyDeviceInfoList);
    /**
     * 提供给第三方接口调用时的批量插入
     * @param tYehuaqiUsers r
     * @return r
     */
    public int insertBatchForThirdParty(List<TDetectorUser> tYehuaqiUsers);
    /**
     * 新增燃气用户和安全装置
     * @param gasUserAndSafetyDeviceVo gas
     * @return r
     */
    public int addUserAndSafetyDevice(GasUserAndSafetyDeviceVo gasUserAndSafetyDeviceVo);

    /**
     * 修改燃气用户和安全装置
     * @param gasUserAndSafetyDeviceVo gas
     * @return r
     */
    public int updateUserAndSafetyDevice(GasUserAndSafetyDeviceVo gasUserAndSafetyDeviceVo);
    /**
     * 批量修改
     * @param list l
     * @return r
     */
    public int updateBatch(List<TDetectorUser> list);

    /**
     * 根据 userId 集合批量删除
     * @param userIds u
     * @return r
     */
    public int deleteBatchSafetyDeviceByUserIds(List<Long> userIds);

    /**
     * 修改燃气用户
     *
     * @param tDetectorUser 燃气用户
     * @return 结果
     */
    public int updateTDetectorUser(TDetectorUser tDetectorUser);

    /**
     * 批量删除燃气用户
     *
     * @param userIds 需要删除的燃气用户ID
     * @return 结果
     */
    public int deleteTDetectorUserByIds(Long[] userIds);

    /**
     * 删除燃气用户信息
     *
     * @param userId 燃气用户ID
     * @return 结果
     */
    public int deleteTDetectorUserById(Long userId);

    /**
     * 查询用户数量
     * @return
     */
    public Map<String,Object> selectUserNum();


    /**
     * 查询用户统计信息
     * @return
     */
    TDetectorUserCount userStatistics(String id);

    /**
     * 获取用户安检信息
     * @param inspectVo
     * @return
     */
    List<TDetectorUserInspectVo> getDetectorUserInspectInfo(TDetectorUserInspectVo inspectVo);


    /**
     * 导入企业信息
     *
     * @param XmbhList 用户数据列表
     * @param isUpdateSupport 是否更新支持，如果已存在，则进行更新数据
     * @param operName 操作用户
     * @return 结果
     */
    public String importEmployedPeopleInfo(List<UserManageGasUserExportVo> XmbhList, Boolean isUpdateSupport, String operName, HttpServletResponse response);


    /**
     * 处理 解析好的 导入的数据
     * @param dataInfos d
     */
    public void handleCustomImportData(List<UserManageGasUserExportVo> dataInfos, boolean updateSupport ) ;

    /**
     * 处理 解析好的 多sheet 导入的数据
     * @param gasUserExportVos g
     * @param safetyDeviceExportVos s
     */
    public void handleCustomMoreSheetImportData(List<UserManageGasUserExportVo> gasUserExportVos,
                                                List<UserManageSafetyDeviceExportVo> safetyDeviceExportVos,
                                                boolean updateSupport ,boolean reImportOfIncorrectDataFlag,String gasType) ;

    /**
     * 根据企业id统计错误数据
     * @return r
     */
    public int countByBeyondEnterpriseId(String code);


    /**
     * 根据企业id 清除数据
     * @return r
     */
    public int clearImportErrorByEnterpriseId(String code);
}
