package com.zehong.system.service;

import com.zehong.common.core.domain.AjaxResult;
import com.zehong.system.domain.TComplainDealTransfer;

import java.util.List;
import java.util.Map;

/**
 * 燃气投诉处置-转办记录Service接口
 * 
 * @author zehong
 * @date 2024-06-06
 */
public interface ITComplainDealTransferService 
{
    /**
     * 查询燃气投诉处置-转办记录
     * 
     * @param complainDealTransferId 燃气投诉处置-转办记录ID
     * @return 燃气投诉处置-转办记录
     */
    public TComplainDealTransfer selectTComplainDealTransferById(Long complainDealTransferId);

    /**
     * 查询燃气投诉处置-转办记录列表
     * 
     * @param tComplainDealTransfer 燃气投诉处置-转办记录
     * @return 燃气投诉处置-转办记录集合
     */
    public List<TComplainDealTransfer> selectTComplainDealTransferList(TComplainDealTransfer tComplainDealTransfer);

    /**
     * 根据 投诉处置id查询 转办记录列表
     * @param complainDealId id
     * @return list
     */
    public List<Map<String,Object>> queryComplainDealTransferListByComplainDealId(Long complainDealId);

    /**
     * 新增燃气投诉处置-转办记录
     * 
     * @param tComplainDealTransfer 燃气投诉处置-转办记录
     * @return 结果
     */
    public AjaxResult insertTComplainDealTransfer(TComplainDealTransfer tComplainDealTransfer);

    /**
     * 修改燃气投诉处置-转办记录
     * 
     * @param tComplainDealTransfer 燃气投诉处置-转办记录
     * @return 结果
     */
    public int updateTComplainDealTransfer(TComplainDealTransfer tComplainDealTransfer);

    /**
     * 批量删除燃气投诉处置-转办记录
     * 
     * @param complainDealTransferIds 需要删除的燃气投诉处置-转办记录ID
     * @return 结果
     */
    public int deleteTComplainDealTransferByIds(Long[] complainDealTransferIds);

    /**
     * 删除燃气投诉处置-转办记录信息
     * 
     * @param complainDealTransferId 燃气投诉处置-转办记录ID
     * @return 结果
     */
    public int deleteTComplainDealTransferById(Long complainDealTransferId);
}
