package com.zehong.system.mapper;

import com.zehong.system.domain.TVehicleLocationInfo;

import java.util.List;

/**
 * 燃气车辆位置信息Mapper接口
 * 
 * @author zehong
 * @date 2022-03-17
 */
public interface TVehicleLocationInfoMapper 
{
    /**
     * 查询燃气车辆位置信息
     * 
     * @param vehicleLocationId 燃气车辆位置信息ID
     * @return 燃气车辆位置信息
     */
    public TVehicleLocationInfo selectTVehicleLocationInfoById(Long vehicleLocationId);

    /**
     * 查询燃气车辆位置信息列表
     * 
     * @param tVehicleLocationInfo 燃气车辆位置信息
     * @return 燃气车辆位置信息集合
     */
    public List<TVehicleLocationInfo> selectTVehicleLocationInfoList(TVehicleLocationInfo tVehicleLocationInfo);

    /**
     * 新增燃气车辆位置信息
     * 
     * @param tVehicleLocationInfo 燃气车辆位置信息
     * @return 结果
     */
    public int insertTVehicleLocationInfo(TVehicleLocationInfo tVehicleLocationInfo);

    /**
     * 修改燃气车辆位置信息
     * 
     * @param tVehicleLocationInfo 燃气车辆位置信息
     * @return 结果
     */
    public int updateTVehicleLocationInfo(TVehicleLocationInfo tVehicleLocationInfo);

    /**
     * 删除燃气车辆位置信息
     * 
     * @param vehicleLocationId 燃气车辆位置信息ID
     * @return 结果
     */
    public int deleteTVehicleLocationInfoById(Long vehicleLocationId);

    /**
     * 批量删除燃气车辆位置信息
     * 
     * @param vehicleLocationIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTVehicleLocationInfoByIds(Long[] vehicleLocationIds);
}
