package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TSupMajorHazard;

/**
 * 重大危险源监管Mapper接口
 * 
 * @author zehong
 * @date 2024-04-19
 */
public interface TSupMajorHazardMapper 
{
    /**
     * 查询重大危险源监管
     * 
     * @param fHazardId 重大危险源监管ID
     * @return 重大危险源监管
     */
    public TSupMajorHazard selectTSupMajorHazardById(Long fHazardId);

    /**
     * 查询重大危险源监管列表
     * 
     * @param tSupMajorHazard 重大危险源监管
     * @return 重大危险源监管集合
     */
    public List<TSupMajorHazard> selectTSupMajorHazardList(TSupMajorHazard tSupMajorHazard);

    /**
     * 查询重大危险源监管列表 导出
     *
     * @param tSupMajorHazard 重大危险源监管
     * @return 重大危险源监管集合
     */
    public List<TSupMajorHazard> exportselectTSupMajorHazardList(TSupMajorHazard tSupMajorHazard);

    /**
     * 新增重大危险源监管
     * 
     * @param tSupMajorHazard 重大危险源监管
     * @return 结果
     */
    public int insertTSupMajorHazard(TSupMajorHazard tSupMajorHazard);

    /**
     * 修改重大危险源监管
     * 
     * @param tSupMajorHazard 重大危险源监管
     * @return 结果
     */
    public int updateTSupMajorHazard(TSupMajorHazard tSupMajorHazard);

    /**
     * 删除重大危险源监管
     * 
     * @param fHazardId 重大危险源监管ID
     * @return 结果
     */
    public int deleteTSupMajorHazardById(Long fHazardId);

    /**
     * 批量删除重大危险源监管
     * 
     * @param fHazardIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTSupMajorHazardByIds(Long[] fHazardIds);
}
