package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TProAppInforBrowse;

/**
 * 行业专家库-专家库浏览Mapper接口
 * 
 * @author zehong
 * @date 2024-05-08
 */
public interface TProAppInforBrowseMapper 
{
    /**
     * 查询行业专家库-专家库浏览
     * 
     * @param fProAppInforId 行业专家库-专家库浏览ID
     * @return 行业专家库-专家库浏览
     */
    public TProAppInforBrowse selectTProAppInforBrowseById(Long fProAppInforId);

    /**
     * 查询行业专家库-专家库浏览列表
     * 
     * @param tProAppInforBrowse 行业专家库-专家库浏览
     * @return 行业专家库-专家库浏览集合
     */
    public List<TProAppInforBrowse> selectTProAppInforBrowseList(TProAppInforBrowse tProAppInforBrowse);

    /**
     * 新增行业专家库-专家库浏览
     * 
     * @param tProAppInforBrowse 行业专家库-专家库浏览
     * @return 结果
     */
    public int insertTProAppInforBrowse(TProAppInforBrowse tProAppInforBrowse);

    /**
     * 修改行业专家库-专家库浏览
     * 
     * @param tProAppInforBrowse 行业专家库-专家库浏览
     * @return 结果
     */
    public int updateTProAppInforBrowse(TProAppInforBrowse tProAppInforBrowse);

    /**
     * 删除行业专家库-专家库浏览
     * 
     * @param fProAppInforId 行业专家库-专家库浏览ID
     * @return 结果
     */
    public int deleteTProAppInforBrowseById(Long fProAppInforId);

    /**
     * 批量删除行业专家库-专家库浏览
     * 
     * @param fProAppInforIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTProAppInforBrowseByIds(Long[] fProAppInforIds);

    /**
     * 批量新增
     * @param list 批量数据
     * @return
     */
    int batchInsertTProAppInforBrowse(List<TProAppInforBrowse> list);
}
