package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TLpgAirChargeFiles;
import org.apache.ibatis.annotations.Param;

/**
 * 液化石油气-充装记录Mapper接口
 * 
 * @author zehong
 * @date 2024-07-09
 */
public interface TLpgAirChargeFilesMapper 
{
    /**
     * 查询液化石油气-充装记录
     * 
     * @param gasAirChargeId 液化石油气-充装记录ID
     * @return 液化石油气-充装记录
     */
    public TLpgAirChargeFiles selectTLpgAirChargeFilesById(Long gasAirChargeId);

    public Integer selectTLpgAirChargeFilesTotal();

    /**
     * 查询液化石油气-充装记录列表
     * 
     * @param tLpgAirChargeFiles 液化石油气-充装记录
     * @return 液化石油气-充装记录集合
     */
    public List<TLpgAirChargeFiles> selectTLpgAirChargeFilesList(TLpgAirChargeFiles tLpgAirChargeFiles);

    /**
     * 2024-09-12 wh 查询数据为了导出用 限制导出数量
     * @param tLpgAirChargeFiles t
     * @return r
     */
    public List<TLpgAirChargeFiles> queryAllForExport(TLpgAirChargeFiles tLpgAirChargeFiles);

    /**
     * 根据 集合 里面的 气瓶条码 和 充装记录编号 查询 数据
     * @param tLpgAirChargeFiles s
     * @return r
     */
    public List<TLpgAirChargeFiles> queryALlByBarcodeAndGizId(@Param("list") List<TLpgAirChargeFiles> tLpgAirChargeFiles);


    /**
     * 根据气瓶条码 查询 最近的两条充装记录
     * @param barCode r
     * @return r
     */
    public List<TLpgAirChargeFiles> queryAllByBarCodeLimit2(String barCode);
    /**
     * 新增液化石油气-充装记录
     * 
     * @param tLpgAirChargeFiles 液化石油气-充装记录
     * @return 结果
     */
    public int insertTLpgAirChargeFiles(TLpgAirChargeFiles tLpgAirChargeFiles);

    /**
     * 批量插入
     * @param list l
     * @return r
     */
    public int insertBatch(@Param("list") List<TLpgAirChargeFiles> list);

    /**
     * 批量修改
     * @param list l
     * @return r
     */
    public int updateBatch(@Param("list") List<TLpgAirChargeFiles> list);

    /**
     * 修改液化石油气-充装记录
     * 
     * @param tLpgAirChargeFiles 液化石油气-充装记录
     * @return 结果
     */
    public int updateTLpgAirChargeFiles(TLpgAirChargeFiles tLpgAirChargeFiles);

    /**
     * 删除液化石油气-充装记录
     * 
     * @param gasAirChargeId 液化石油气-充装记录ID
     * @return 结果
     */
    public int deleteTLpgAirChargeFilesById(Long gasAirChargeId);

    /**
     * 批量删除液化石油气-充装记录
     * 
     * @param fGasAirChargeIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTLpgAirChargeFilesByIds(Long[] fGasAirChargeIds);
}
