package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TLinePatrolPerson;

/**
 * 巡线人员管理Mapper接口
 * 
 * @author zehong
 * @date 2023-09-13
 */
public interface TLinePatrolPersonMapper 
{
    /**
     * 查询巡线人员管理
     * 
     * @param personId 巡线人员管理ID
     * @return 巡线人员管理
     */
    public TLinePatrolPerson selectTLinePatrolPersonById(Long personId);

    /**
     * 查询巡线人员管理列表
     * 
     * @param tLinePatrolPerson 巡线人员管理
     * @return 巡线人员管理集合
     */
    public List<TLinePatrolPerson> selectTLinePatrolPersonList(TLinePatrolPerson tLinePatrolPerson);

    /**
     * 小程序
     * @param tLinePatrolPerson
     * @return
     */
    public List<TLinePatrolPerson> appPersonList(TLinePatrolPerson tLinePatrolPerson);


    /**
     * 新增巡线人员管理
     * 
     * @param tLinePatrolPerson 巡线人员管理
     * @return 结果
     */
    public int insertTLinePatrolPerson(TLinePatrolPerson tLinePatrolPerson);

    /**
     * 修改巡线人员管理
     * 
     * @param tLinePatrolPerson 巡线人员管理
     * @return 结果
     */
    public int updateTLinePatrolPerson(TLinePatrolPerson tLinePatrolPerson);

    /**
     * 删除巡线人员管理
     * 
     * @param personId 巡线人员管理ID
     * @return 结果
     */
    public int deleteTLinePatrolPersonById(Long personId);

    /**
     * 批量删除巡线人员管理
     * 
     * @param personIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTLinePatrolPersonByIds(Long[] personIds);
}
