package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TEmergencyDrills;

/**
 * 应急演练Mapper接口
 * 
 * @author zehong
 * @date 2024-04-19
 */
public interface TEmergencyDrillsMapper 
{
    /**
     * 查询应急演练
     * 
     * @param fDrillsId 应急演练ID
     * @return 应急演练
     */
    public TEmergencyDrills selectTEmergencyDrillsById(Long fDrillsId);

    /**
     * 查询应急演练列表
     * 
     * @param tEmergencyDrills 应急演练
     * @return 应急演练集合
     */
    public List<TEmergencyDrills> selectTEmergencyDrillsList(TEmergencyDrills tEmergencyDrills);

    /**
     * 新增应急演练
     * 
     * @param tEmergencyDrills 应急演练
     * @return 结果
     */
    public int insertTEmergencyDrills(TEmergencyDrills tEmergencyDrills);

    /**
     * 修改应急演练
     * 
     * @param tEmergencyDrills 应急演练
     * @return 结果
     */
    public int updateTEmergencyDrills(TEmergencyDrills tEmergencyDrills);

    /**
     * 删除应急演练
     * 
     * @param fDrillsId 应急演练ID
     * @return 结果
     */
    public int deleteTEmergencyDrillsById(Long fDrillsId);

    /**
     * 批量删除应急演练
     * 
     * @param fDrillsIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTEmergencyDrillsByIds(Long[] fDrillsIds);
}
